/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LimitFinder
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final MinMaxMutable minmax;
    private UClip clip;
    private static final double HACK_X_FOR_POLYGON = 10.0;

    public boolean matchesProperty(String string) {
        return false;
    }

    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new LimitFinder(this.stringBounder, this.minmax, this.translate.compose((UTranslate)uChange), this.clip);
        }
        if (uChange instanceof UStroke) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UChangeBackColor) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UChangeColor) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UHidden) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UAntiAliasing) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UClip) {
            LimitFinder limitFinder = new LimitFinder(this);
            limitFinder.clip = (UClip)uChange;
            limitFinder.clip = limitFinder.clip.translate(this.translate);
            return limitFinder;
        }
        throw new UnsupportedOperationException(uChange.getClass().toString());
    }

    public LimitFinder(StringBounder stringBounder, boolean bl) {
        this(stringBounder, MinMaxMutable.getEmpty(bl), new UTranslate(), null);
    }

    private LimitFinder(StringBounder stringBounder, MinMaxMutable minMaxMutable, UTranslate uTranslate, UClip uClip) {
        this.stringBounder = stringBounder;
        this.minmax = minMaxMutable;
        this.translate = uTranslate;
        this.clip = uClip;
    }

    private LimitFinder(LimitFinder limitFinder) {
        this(limitFinder.stringBounder, limitFinder.minmax, limitFinder.translate, limitFinder.clip);
    }

    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public UParam getParam() {
        return new UParamNull();
    }

    private void addPoint(double d, double d2) {
        if (this.clip == null || this.clip.isInside(d, d2)) {
            this.minmax.addPoint(d, d2);
        }
    }

    public void draw(UShape uShape) {
        double d = this.translate.getDx();
        double d2 = this.translate.getDy();
        if (uShape instanceof UText) {
            this.drawText(d, d2, (UText)uShape);
        } else if (uShape instanceof ULine) {
            this.drawULine(d, d2, (ULine)uShape);
        } else if (uShape instanceof UEllipse) {
            this.drawEllipse(d, d2, (UEllipse)uShape);
        } else if (uShape instanceof UPolygon) {
            this.drawUPolygon(d, d2, (UPolygon)uShape);
        } else if (uShape instanceof UPath) {
            this.drawUPath(d, d2, (UPath)uShape);
        } else if (uShape instanceof URectangle) {
            this.drawRectangle(d, d2, (URectangle)uShape);
        } else if (uShape instanceof DotPath) {
            this.drawDotPath(d, d2, (DotPath)uShape);
        } else if (uShape instanceof UImage) {
            this.drawImage(d, d2, (UImage)uShape);
        } else if (uShape instanceof UImageSvg) {
            this.drawImageSvg(d, d2, (UImageSvg)uShape);
        } else if (!(uShape instanceof UComment)) {
            if (uShape instanceof UEmpty) {
                this.drawEmpty(d, d2, (UEmpty)uShape);
            } else if (uShape instanceof TextBlock) {
                TextBlock textBlock = (TextBlock)uShape;
                textBlock.drawU(this);
            } else if (!(uShape instanceof UCenteredCharacter)) {
                if (uShape instanceof UPixel) {
                    this.addPoint(d, d2);
                } else {
                    throw new UnsupportedOperationException(uShape.getClass().getName());
                }
            }
        }
    }

    private void drawEmpty(double d, double d2, UEmpty uEmpty) {
        this.addPoint(d, d2);
        this.addPoint(d + uEmpty.getWidth(), d2 + uEmpty.getHeight());
    }

    private void drawUPath(double d, double d2, UPath uPath) {
        this.addPoint(d + uPath.getMinX(), d2 + uPath.getMinY());
        this.addPoint(d + uPath.getMaxX(), d2 + uPath.getMaxY());
    }

    private void drawUPolygon(double d, double d2, UPolygon uPolygon) {
        if (uPolygon.getPoints().size() == 0) {
            return;
        }
        this.addPoint(d + uPolygon.getMinX() - 10.0, d2 + uPolygon.getMinY());
        this.addPoint(d + uPolygon.getMaxX() + 10.0, d2 + uPolygon.getMaxY());
    }

    private void drawULine(double d, double d2, ULine uLine) {
        this.addPoint(d, d2);
        this.addPoint(d + uLine.getDX(), d2 + uLine.getDY());
    }

    private void drawRectangle(double d, double d2, URectangle uRectangle) {
        this.addPoint(d, d2);
        this.addPoint(d + uRectangle.getWidth() - 1.0, d2 + uRectangle.getHeight() - 1.0);
    }

    private void drawDotPath(double d, double d2, DotPath dotPath) {
        MinMax minMax = dotPath.getMinMax();
        this.addPoint(d + minMax.getMinX(), d2 + minMax.getMinY());
        this.addPoint(d + minMax.getMaxX(), d2 + minMax.getMaxY());
    }

    private void drawImage(double d, double d2, UImage uImage) {
        this.addPoint(d, d2);
        this.addPoint(d + uImage.getWidth() - 1.0, d2 + uImage.getHeight() - 1.0);
    }

    private void drawImageSvg(double d, double d2, UImageSvg uImageSvg) {
        this.addPoint(d, d2);
        this.addPoint(d + (double)uImageSvg.getWidth() - 1.0, d2 + (double)uImageSvg.getHeight() - 1.0);
    }

    private void drawEllipse(double d, double d2, UEllipse uEllipse) {
        this.addPoint(d, d2);
        this.addPoint(d + uEllipse.getWidth() - 1.0, d2 + uEllipse.getHeight() - 1.0);
    }

    private void drawText(double d, double d2, UText uText) {
        Dimension2D dimension2D = this.stringBounder.calculateDimension(uText.getFontConfiguration().getFont(), uText.getText());
        this.addPoint(d, d2 -= dimension2D.getHeight() - 1.5);
        this.addPoint(d, d2 + dimension2D.getHeight());
        this.addPoint(d + dimension2D.getWidth(), d2);
        this.addPoint(d + dimension2D.getWidth(), d2 + dimension2D.getHeight());
    }

    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public MinMax getMinMax() {
        if (this.minmax.isInfinity()) {
            return MinMax.getEmpty(true);
        }
        return MinMax.fromMutable(this.minmax);
    }

    public void flushUg() {
    }
}

