/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimingRuler {
    private final SortedSet<TimeTick> times = new TreeSet<TimeTick>();
    private long highestCommonFactor = -1L;
    private final ISkinParam skinParam;
    private long tickIntervalInPixels = 50L;
    private long tickUnitary;

    public void scaleInPixels(long l, long l2) {
        this.tickIntervalInPixels = l2;
        this.tickUnitary = l;
    }

    private long tickUnitary() {
        if (this.tickUnitary == 0L) {
            return this.highestCommonFactor;
        }
        return this.tickUnitary;
    }

    private int getNbTick() {
        return (int)(1L + this.getMax().getTime().longValue() / this.tickUnitary());
    }

    public double getWidth() {
        return this.getPosInPixel(new BigDecimal((long)this.getNbTick() * this.tickUnitary()));
    }

    private double getPosInPixel(double d) {
        return d / (double)this.tickUnitary() * (double)this.tickIntervalInPixels;
    }

    public TimingRuler(ISkinParam iSkinParam) {
        this.skinParam = iSkinParam;
    }

    public void addTime(TimeTick timeTick) {
        long l;
        boolean bl = this.times.add(timeTick);
        if (bl && (l = timeTick.getTime().longValue()) > 0L) {
            this.highestCommonFactor = this.highestCommonFactor == -1L ? timeTick.getTime().longValue() : TimingRuler.computeHighestCommonFactor(this.highestCommonFactor, timeTick.getTime().longValue());
        }
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    private TextBlock getTimeTextBlock(long l) {
        Display display = Display.getWithNewlines("" + l);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void draw(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UStroke(2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        ULine uLine = new ULine(0.0, 5.0);
        int n = this.getNbTick();
        for (int i = 0; i <= n; ++i) {
            uGraphic.apply(new UTranslate(this.tickIntervalInPixels * (long)i, 0.0)).draw(uLine);
        }
        uGraphic.draw(new ULine((long)n * this.tickIntervalInPixels, 0.0));
        for (long l : this.roundValues()) {
            TextBlock textBlock = this.getTimeTextBlock(l);
            Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
            textBlock.drawU(uGraphic.apply(new UTranslate(this.getPosInPixel(l) - dimension2D.getWidth() / 2.0, 6.0)));
        }
    }

    private Collection<Long> roundValues() {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        if (this.tickUnitary == 0L) {
            for (TimeTick timeTick : this.times) {
                long l = timeTick.getTime().longValue();
                treeSet.add(l);
            }
        } else {
            int n = this.getNbTick();
            for (int i = 0; i <= n; ++i) {
                long l = this.tickUnitary * (long)i;
                treeSet.add(l);
            }
        }
        return treeSet;
    }

    private TimeTick getMax() {
        if (this.times.size() == 0) {
            throw new IllegalStateException("Empty list!");
        }
        return this.times.last();
    }

    private static long computeHighestCommonFactor(long l, long l2) {
        long l3 = l;
        while (l3 != 0L) {
            l3 = l % l2;
            l = l2;
            l2 = l3;
        }
        return Math.abs(l);
    }

    public final double getPosInPixel(BigDecimal bigDecimal) {
        return this.getPosInPixel(bigDecimal.doubleValue());
    }

    public final double getPosInPixel(TimeTick timeTick) {
        return this.getPosInPixel(timeTick.getTime());
    }

    public final double getMaxPosInPixel() {
        return this.getPosInPixel(this.getMax());
    }
}

