/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.HexaShape;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.PentaAShape;
import net.sourceforge.plantuml.timingdiagram.PentaBShape;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Ribbon
implements TimeDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final double delta = 12.0;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;
    private Colors initialColors;

    public Ribbon(TimingRuler timingRuler, ISkinParam iSkinParam) {
        this.ruler = timingRuler;
        this.skinParam = iSkinParam;
    }

    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick timeTick) {
        double d = this.ruler.getPosInPixel(timeTick);
        double d2 = 6.0 + this.getHeightForConstraints();
        for (ChangeState changeState : this.changes) {
            if (changeState.getWhen().compareTo(timeTick) != 0) continue;
            return new IntricatedPoint(new Point2D.Double(d, d2), new Point2D.Double(d, d2));
        }
        return new IntricatedPoint(new Point2D.Double(d, d2 - 12.0), new Point2D.Double(d, d2 + 12.0));
    }

    public void addChange(ChangeState changeState) {
        this.changes.add(changeState);
    }

    private double getPosInPixel(ChangeState changeState) {
        return this.ruler.getPosInPixel(changeState.getWhen());
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    private TextBlock getTextBlock(String string) {
        Display display = Display.getWithNewlines(string);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawU(UGraphic uGraphic) {
        double d;
        TextBlock textBlock;
        UGraphic uGraphic2 = uGraphic.apply(new UTranslate(0.0, this.getHeightForConstraints()));
        StringBounder stringBounder = uGraphic2.getStringBounder();
        if (this.initialState == null) {
            textBlock = null;
        } else {
            textBlock = this.getTextBlock(this.initialState);
            double d2 = this.getPosInPixel(this.changes.get(0));
            this.drawPentaA(uGraphic2.apply(new UTranslate(-this.getInitialWidth(stringBounder), -6.0)), this.getInitialWidth(stringBounder) + d2, this.changes.get(0));
        }
        for (int i = 0; i < this.changes.size() - 1; ++i) {
            d = this.getPosInPixel(this.changes.get(i));
            double d3 = this.getPosInPixel(this.changes.get(i + 1));
            assert (d3 > d);
            if (this.changes.get(i).isCompletelyHidden()) continue;
            this.drawHexa(uGraphic2.apply(new UTranslate(d, -6.0)), d3 - d, this.changes.get(i));
        }
        if (this.changes.size() >= 1) {
            ChangeState changeState = this.changes.get(this.changes.size() - 1);
            d = this.getPosInPixel(changeState);
            if (!changeState.isCompletelyHidden()) {
                this.drawPentaB(uGraphic2.apply(new UTranslate(d, -6.0)), this.ruler.getWidth() - d, changeState);
            }
        }
        uGraphic2 = uGraphic2.apply(new UTranslate(0.0, 6.0));
        if (textBlock != null) {
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            textBlock.drawU(uGraphic2.apply(new UTranslate(-this.getDelta() - dimension2D.getWidth(), -dimension2D.getHeight() / 2.0)));
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            Object object;
            Object object2;
            ChangeState changeState = this.changes.get(i);
            double d4 = this.ruler.getPosInPixel(changeState.getWhen());
            if (!changeState.isBlank() && !changeState.isCompletelyHidden()) {
                double d5;
                object2 = this.getTextBlock(changeState.getState());
                object = object2.calculateDimension(stringBounder);
                if (i == this.changes.size() - 1) {
                    d5 = d4 + this.getDelta();
                } else {
                    double d6 = this.ruler.getPosInPixel(this.changes.get(i + 1).getWhen());
                    d5 = (d4 + d6) / 2.0 - ((Dimension2D)object).getWidth() / 2.0;
                }
                object2.drawU(uGraphic2.apply(new UTranslate(d5, -((Dimension2D)object).getHeight() / 2.0)));
            }
            if ((object2 = changeState.getComment()) == null) continue;
            object = this.getTextBlock((String)object2);
            Dimension2D dimension2D = object.calculateDimension(stringBounder);
            object.drawU(uGraphic2.apply(new UTranslate(d4 + this.getDelta(), -12.0 - dimension2D.getHeight())));
        }
        for (TimeConstraint timeConstraint : this.constraints) {
            timeConstraint.drawU(uGraphic.apply(new UTranslate(0.0, 15.0)), this.ruler, this.skinParam);
        }
    }

    private double getInitialWidth(StringBounder stringBounder) {
        return this.getTextBlock(this.initialState).calculateDimension(stringBounder).getWidth() + 24.0;
    }

    private void drawHexa(UGraphic uGraphic, double d, ChangeState changeState) {
        HexaShape hexaShape = HexaShape.create(d, 24.0, changeState.getContext());
        hexaShape.drawU(uGraphic);
    }

    private void drawPentaB(UGraphic uGraphic, double d, ChangeState changeState) {
        PentaBShape pentaBShape = PentaBShape.create(d, 24.0, changeState.getContext());
        pentaBShape.drawU(uGraphic);
    }

    private void drawPentaA(UGraphic uGraphic, double d, ChangeState changeState) {
        SymbolContext symbolContext = changeState.getContext();
        HtmlColor htmlColor = this.initialColors.getColor(ColorType.BACK);
        if (htmlColor != null) {
            symbolContext = symbolContext.withBackColor(htmlColor);
        }
        PentaAShape pentaAShape = PentaAShape.create(d, 24.0, symbolContext);
        pentaAShape.drawU(uGraphic);
    }

    private double getHeightForConstraints() {
        if (this.constraints.size() == 0) {
            return 0.0;
        }
        return 30.0;
    }

    public double getHeight() {
        return 36.0 + this.getHeightForConstraints();
    }

    public double getDelta() {
        return 12.0;
    }

    public TextBlock getWidthHeader(StringBounder stringBounder) {
        if (this.initialState != null) {
            return TextBlockUtils.empty(this.getInitialWidth(stringBounder), 24.0);
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    public void setInitialState(String string, Colors colors) {
        this.initialState = string;
        this.initialColors = colors;
    }

    public void addConstraint(TimeConstraint timeConstraint) {
        this.constraints.add(timeConstraint);
    }
}

