/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandConstraint
extends SingleLineCommand2<TimingDiagram> {
    public CommandConstraint() {
        super(CommandConstraint.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PART1", "(([\\p{L}_][\\p{L}0-9_.]*))?"), TimeTickBuilder.expressionAtWithArobase("TIME1"), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW", "\\<(-+)\\>"), new RegexLeaf("[%s]*"), TimeTickBuilder.expressionAtWithArobase("TIME2"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram timingDiagram, RegexResult regexResult) {
        Player player;
        String string = regexResult.get("PART1", 0);
        if (string == null) {
            player = timingDiagram.getLastPlayer();
            if (player == null) {
                return CommandExecutionResult.error("You have to provide a participant");
            }
        } else {
            player = timingDiagram.getPlayer(string);
        }
        TimeTick timeTick = TimeTickBuilder.parseTimeTick("TIME1", regexResult, timingDiagram);
        timingDiagram.updateNow(timeTick);
        TimeTick timeTick2 = TimeTickBuilder.parseTimeTick("TIME2", regexResult, timingDiagram);
        player.createConstraint(timeTick, timeTick2, regexResult.get("MESSAGE", 0));
        return CommandExecutionResult.ok();
    }
}

