/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandChangeStateByPlayerCode
extends SingleLineCommand2<TimingDiagram> {
    private static final String STATE_CODE = "([\\p{L}0-9_][\\p{L}0-9_.]*)";

    public CommandChangeStateByPlayerCode() {
        super(CommandChangeStateByPlayerCode.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), new RegexLeaf("[%s]*is[%s]*"), CommandChangeStateByPlayerCode.getStateOrHidden(), new RegexLeaf("[%s]*"), CommandChangeStateByPlayerCode.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("COMMENT", "(?:[%s]*:[%s]*(.*?))?"), new RegexLeaf("[%s]*$"));
    }

    static IRegex getStateOrHidden() {
        return new RegexOr(new RegexLeaf("STATE1", "[%g]([^%g]+)[%g]"), new RegexLeaf("STATE2", STATE_CODE), new RegexLeaf("STATE3", "(\\{hidden\\})"), new RegexLeaf("STATE4", "(\\{\\.\\.\\.\\})"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram timingDiagram, RegexResult regexResult) {
        String string = regexResult.get("CODE", 0);
        Player player = timingDiagram.getPlayer(string);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + string + "\"");
        }
        String string2 = regexResult.get("COMMENT", 0);
        TimeTick timeTick = timingDiagram.getNow();
        Colors colors = CommandChangeStateByPlayerCode.color().getColor(regexResult, timingDiagram.getSkinParam().getIHtmlColorSet());
        player.setState(timeTick, regexResult.getLazzy("STATE", 0), string2, colors);
        return CommandExecutionResult.ok();
    }
}

