/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import net.sourceforge.plantuml.GeneratedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleLine2
implements Comparable<SimpleLine2> {
    private final File file;
    private final GeneratedImage generatedImage;
    private final Future<List<GeneratedImage>> future;

    public static SimpleLine2 fromFuture(File file, Future<List<GeneratedImage>> future) {
        return new SimpleLine2(file, null, future);
    }

    public static SimpleLine2 fromGeneratedImage(File file, GeneratedImage generatedImage) {
        return new SimpleLine2(file, generatedImage, null);
    }

    private SimpleLine2(File file, GeneratedImage generatedImage, Future<List<GeneratedImage>> future) {
        this.generatedImage = generatedImage;
        this.file = file;
        this.future = future;
    }

    public File getFile() {
        return this.file;
    }

    public boolean pendingAndFinished() {
        return this.generatedImage == null && this.future.isDone();
    }

    public String toString() {
        if (this.generatedImage == null) {
            return this.file.getName() + " (...pending...)";
        }
        StringBuilder stringBuilder = new StringBuilder(this.generatedImage.getPngFile().getName());
        stringBuilder.append(" ");
        stringBuilder.append(this.generatedImage.getDescription());
        return stringBuilder.toString();
    }

    public Future<List<GeneratedImage>> getFuture() {
        return this.future;
    }

    @Override
    public int compareTo(SimpleLine2 simpleLine2) {
        return this.toString().compareTo(simpleLine2.toString());
    }

    public GeneratedImage getGeneratedImage() {
        return this.generatedImage;
    }
}

