/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.swing.ImageHelper;
import net.sourceforge.plantuml.swing.ImageSelection;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.swing.ScrollablePicture;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.version.PSystemVersion;

class ImageWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(ImageWindow2.class);
    private static final String KEY_ZOOM_FIT = "zoomfit";
    private SimpleLine2 simpleLine2;
    private final JScrollPane scrollPane;
    private final JButton next = new JButton("Next");
    private final JButton copy = new JButton("Copy");
    private final JButton previous = new JButton("Previous");
    private final JCheckBox zoomFitButt = new JCheckBox("Zoom fit");
    private final JButton zoomMore = new JButton("+");
    private final JButton zoomLess = new JButton("-");
    private final MainWindow2 main;
    private final ListModel listModel;
    private int index;
    private int zoomFactor = 0;
    private SizeMode sizeMode = SizeMode.FULL_SIZE;
    private int startX;
    private int startY;
    private int v1;
    private int v2;

    public ImageWindow2(SimpleLine2 simpleLine2, final MainWindow2 mainWindow2, ListModel listModel, int n) {
        super(simpleLine2.toString());
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.simpleLine2 = simpleLine2;
        this.listModel = listModel;
        this.index = n;
        this.main = mainWindow2;
        JPanel jPanel = new JPanel();
        jPanel.add(this.previous);
        jPanel.add(this.copy);
        jPanel.add(this.next);
        jPanel.add(this.zoomFitButt);
        jPanel.add(this.zoomMore);
        jPanel.add(this.zoomLess);
        this.copy.setFocusable(false);
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.copy();
            }
        });
        this.next.setFocusable(false);
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.next();
            }
        });
        this.previous.setFocusable(false);
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.previous();
            }
        });
        this.zoomFitButt.setFocusable(false);
        this.zoomFitButt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.zoomFit();
            }
        });
        this.zoomMore.setFocusable(false);
        this.zoomMore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.zoomFactor++;
                ImageWindow2.this.refreshImage(false);
            }
        });
        this.zoomLess.setFocusable(false);
        this.zoomLess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow2.this.zoomFactor--;
                ImageWindow2.this.refreshImage(false);
            }
        });
        this.scrollPane = new JScrollPane(this.buildScrollablePicture());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                mainWindow2.closing(ImageWindow2.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                ImageWindow2.this.refreshImage(false);
            }
        });
        boolean bl = prefs.getBoolean(KEY_ZOOM_FIT, false);
        this.zoomFitButt.setSelected(bl);
        if (bl) {
            this.sizeMode = SizeMode.ZOOM_FIT;
        }
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (keyEvent.getKeyCode() == 39) {
                    ImageWindow2.this.imageRight();
                } else if (keyEvent.getKeyCode() == 37) {
                    ImageWindow2.this.imageLeft();
                } else if (keyEvent.getKeyCode() == 40) {
                    ImageWindow2.this.imageDown();
                } else if (keyEvent.getKeyCode() == 38) {
                    ImageWindow2.this.imageUp();
                } else if (keyEvent.getKeyCode() == 67) {
                    ImageWindow2.this.copy();
                } else if (keyEvent.getKeyCode() == 90) {
                    ImageWindow2.this.zoomFitButt.setSelected(!ImageWindow2.this.zoomFitButt.isSelected());
                    ImageWindow2.this.zoomFit();
                }
            }
        });
    }

    private void next() {
        ++this.index;
        this.updateSimpleLine();
    }

    private void previous() {
        --this.index;
        this.updateSimpleLine();
    }

    private void imageDown() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement());
    }

    private void imageUp() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getBlockIncrement());
    }

    private void imageLeft() {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getBlockIncrement());
    }

    private void imageRight() {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement());
    }

    private void zoomFit() {
        boolean bl = this.zoomFitButt.isSelected();
        prefs.putBoolean(KEY_ZOOM_FIT, bl);
        this.zoomFactor = 0;
        this.sizeMode = bl ? SizeMode.ZOOM_FIT : SizeMode.FULL_SIZE;
        this.refreshImage(false);
    }

    private void updateSimpleLine() {
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.listModel.getSize() - 1) {
            this.index = this.listModel.getSize() - 1;
        }
        this.simpleLine2 = (SimpleLine2)this.listModel.getElementAt(this.index);
        this.setTitle(this.simpleLine2.toString());
        this.refreshImage(false);
    }

    private void refreshSimpleLine() {
        for (SimpleLine2 simpleLine2 : this.main.getCurrentDirectoryListing2()) {
            if (!simpleLine2.getFile().equals(this.simpleLine2.getFile())) continue;
            this.simpleLine2 = simpleLine2;
            this.setTitle(this.simpleLine2.toString());
        }
    }

    private ScrollablePicture buildScrollablePicture() {
        Object object;
        Serializable serializable;
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return null;
        }
        File file = generatedImage.getPngFile();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(file.getAbsolutePath()));
            if (this.sizeMode == SizeMode.ZOOM_FIT) {
                serializable = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                object = ImageHelper.getScaledDimension(serializable, this.scrollPane.getViewport().getSize());
                bufferedImage = ImageHelper.getScaledInstance(bufferedImage, (Dimension)object, this.getHints(), true);
            } else if (this.zoomFactor != 0) {
                serializable = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                object = ImageHelper.getScaledDimension(serializable, this.getZoom());
                bufferedImage = ImageHelper.getScaledInstance(bufferedImage, (Dimension)object, this.getHints(), false);
            }
        }
        catch (IOException iOException) {
            object = "Error reading file: " + iOException.toString();
            IEntityImage iEntityImage = GraphicStrings.createForError(Arrays.asList(object), false);
            ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, iEntityImage.getBackcolor(), null, null, 0.0, 0.0, null, false);
            imageBuilder.setUDrawable(iEntityImage);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), 42L, byteArrayOutputStream);
                byteArrayOutputStream.close();
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        serializable = new ImageIcon(bufferedImage, this.simpleLine2.toString());
        object = new ScrollablePicture((ImageIcon)serializable, 1);
        ((Component)object).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                ImageWindow2.this.startX = mouseEvent.getX();
                ImageWindow2.this.startY = mouseEvent.getY();
            }
        });
        ((Component)object).addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                super.mouseDragged(mouseEvent);
                int n = mouseEvent.getX() - ImageWindow2.this.startX;
                int n2 = mouseEvent.getY() - ImageWindow2.this.startY;
                JScrollBar jScrollBar = ImageWindow2.this.scrollPane.getHorizontalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() - n);
                JScrollBar jScrollBar2 = ImageWindow2.this.scrollPane.getVerticalScrollBar();
                jScrollBar2.setValue(jScrollBar2.getValue() - n2);
            }
        });
        return object;
    }

    private RenderingHints getHints() {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return renderingHints;
    }

    private double getZoom() {
        return Math.pow(1.1, this.zoomFactor);
    }

    private void copy() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return;
        }
        File file = generatedImage.getPngFile();
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public SimpleLine2 getSimpleLine() {
        return this.simpleLine2;
    }

    public void refreshImage(boolean bl) {
        final JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        final JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        if (bl && !this.isError()) {
            this.v1 = jScrollBar.getValue();
            this.v2 = jScrollBar2.getValue();
        }
        this.scrollPane.setViewportView(this.buildScrollablePicture());
        this.force();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageWindow2.this.refreshSimpleLine();
                    if (!ImageWindow2.this.isError()) {
                        jScrollBar.setValue(ImageWindow2.this.v1);
                        jScrollBar2.setValue(ImageWindow2.this.v2);
                    }
                }
            });
        }
    }

    private boolean isError() {
        return this.simpleLine2.getGeneratedImage() != null && this.simpleLine2.getGeneratedImage().lineErrorRaw() != -1;
    }

    private void force() {
        this.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SizeMode {
        FULL_SIZE,
        ZOOM_FIT;

    }
}

