/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockGeneric;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageClassHeader2
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader2(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = iLeaf.getLeafType() == LeafType.ABSTRACT_CLASS || iLeaf.getLeafType() == LeafType.INTERFACE;
        Stereotype stereotype = iLeaf.getStereotype();
        String string = iLeaf.getGeneric();
        FontConfiguration fontConfiguration = new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype);
        if (bl) {
            fontConfiguration = fontConfiguration.italic();
        }
        TextBlock textBlock = iLeaf.getDisplay().createWithNiceCreoleMode(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
        VisibilityModifier visibilityModifier = iLeaf.getVisibilityModifier();
        if (visibilityModifier == null) {
            textBlock = TextBlockUtils.withMargin(textBlock, 3.0, 3.0, 0.0, 0.0);
        } else {
            object4 = new Rose();
            object3 = ((Rose)object4).getHtmlColor(iSkinParam, visibilityModifier.getBackground());
            object2 = ((Rose)object4).getHtmlColor(iSkinParam, visibilityModifier.getForeground());
            object = visibilityModifier.getUBlock(iSkinParam.classAttributeIconSize(), (HtmlColor)object2, (HtmlColor)object3, false);
            textBlock = TextBlockUtils.mergeLR((TextBlock)object, textBlock, VerticalAlignment.CENTER);
            textBlock = TextBlockUtils.withMargin(textBlock, 3.0, 3.0, 0.0, 0.0);
        }
        object4 = stereotype == null || stereotype.getLabel(false) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf) ? null : TextBlockUtils.withMargin(Display.create(stereotype.getLabels(iSkinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, iSkinParam), 1.0, 0.0);
        if (string == null) {
            object3 = null;
        } else {
            object3 = Display.getWithNewlines(string).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, iSkinParam);
            object3 = TextBlockUtils.withMargin((TextBlock)object3, 1.0, 1.0);
            object2 = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.background, stereotype);
            object = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype);
            object3 = new TextBlockGeneric((TextBlock)object3, (HtmlColor)object2, (HtmlColor)object);
            object3 = TextBlockUtils.withMargin((TextBlock)object3, 1.0, 1.0);
        }
        object2 = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, (ILeaf)this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(iLeaf, iSkinParam), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout((TextBlock)object2, (TextBlock)object4, textBlock, (TextBlock)object3);
    }

    private TextBlock getCircledCharacter(ILeaf iLeaf, ISkinParam iSkinParam) {
        Stereotype stereotype = iLeaf.getStereotype();
        if (stereotype != null && stereotype.getSprite() != null) {
            return iSkinParam.getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor(), 1.0);
        }
        UFont uFont = SkinParamUtils.getFont(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        HtmlColor htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, stereotype);
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), uFont, stereotype.getHtmlColor(), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.ANNOTATION) {
            return new CircledCharacter('@', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeNBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeABackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.CLASS) {
            return new CircledCharacter('C', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeCBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.INTERFACE) {
            return new CircledCharacter('I', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeIBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.ENUM) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeEBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getLeafType() == LeafType.ENTITY) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeCBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        assert (false);
        return null;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        this.headerLayout.drawU(uGraphic, d, d2);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

