/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.PortGeometry;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape
implements Positionable,
IShapePseudo,
Hideable {
    private final ShapeType type;
    private final double width;
    private final double height;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private final Margins shield;
    private final EntityPosition entityPosition;
    private final IEntityImage image;
    private Cluster cluster;
    private final boolean top;
    private Shadowable octagon;

    public EntityPosition getEntityPosition() {
        return this.entityPosition;
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        return super.toString() + " " + this.image + " " + (Object)((Object)this.type);
    }

    public Shape(IEntityImage iEntityImage, ShapeType shapeType, double d, double d2, ColorSequence colorSequence, boolean bl, Margins margins, EntityPosition entityPosition) {
        this.entityPosition = entityPosition;
        this.image = iEntityImage;
        this.top = bl;
        this.type = shapeType;
        this.width = d;
        this.height = d2;
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.shield = margins;
        if (!margins.isZero() && shapeType != ShapeType.RECTANGLE && shapeType != ShapeType.RECTANGLE_HTML_FOR_PORTS) {
            throw new IllegalArgumentException();
        }
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @Override
    public void appendShape(StringBuilder stringBuilder, StringBounder stringBounder) {
        if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
            this.appendLabelHtmlSpecialForLink(stringBuilder, stringBounder);
            return;
        }
        if (this.type == ShapeType.RECTANGLE && !this.shield.isZero()) {
            this.appendHtml(stringBuilder);
            return;
        }
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        this.appendShapeInternal(stringBuilder);
        stringBuilder.append(",");
        stringBuilder.append("label=\"\"");
        stringBuilder.append(",");
        stringBuilder.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        stringBuilder.append(",");
        stringBuilder.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        stringBuilder.append(",");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendHtml(StringBuilder stringBuilder) {
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        stringBuilder.append("shape=plaintext,");
        stringBuilder.append("label=<");
        this.appendLabelHtml(stringBuilder);
        stringBuilder.append(">");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendLabelHtml(StringBuilder stringBuilder) {
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, 1.0, this.shield.getY1());
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder, this.shield.getX1(), 1.0);
        stringBuilder.append("<TD BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        stringBuilder.append(" PORT=\"h\">");
        stringBuilder.append("</TD>");
        this.appendTd(stringBuilder, this.shield.getX2(), 1.0);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, 1.0, this.shield.getY2());
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void appendLabelHtmlSpecialForLink(StringBuilder stringBuilder, StringBounder stringBounder) {
        Ports ports = ((WithPorts)((Object)this.image)).getPorts(stringBounder);
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        stringBuilder.append("shape=plaintext,");
        stringBuilder.append("label=<");
        stringBuilder.append("<TABLE BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\" BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        double d = 0.0;
        for (Map.Entry<String, PortGeometry> entry : ports.getAll().entrySet()) {
            String string = entry.getKey();
            PortGeometry portGeometry = entry.getValue();
            double d2 = portGeometry.getPosition() - d;
            this.appendTr(stringBuilder, null, d2);
            this.appendTr(stringBuilder, string, portGeometry.getHeight());
            d = portGeometry.getLastY();
        }
        this.appendTr(stringBuilder, null, this.getHeight() - d);
        stringBuilder.append("</TABLE>");
        stringBuilder.append(">");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendTr(StringBuilder stringBuilder, String string, double d) {
        if (d <= 0.0) {
            return;
        }
        stringBuilder.append("<TR>");
        stringBuilder.append("<TD ");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + d + "\"");
        if (string != null) {
            stringBuilder.append(" PORT=\"" + string + "\"");
        }
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
    }

    private void appendTd(StringBuilder stringBuilder, double d, double d2) {
        stringBuilder.append("<TD");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + d + "\" HEIGHT=\"" + d2 + "\"");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
    }

    private void appendTd(StringBuilder stringBuilder) {
        stringBuilder.append("<TD>");
        stringBuilder.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder stringBuilder) {
        if (this.type == ShapeType.RECTANGLE && !this.shield.isZero()) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE || this.type == ShapeType.FOLDER) {
            stringBuilder.append("shape=rect");
        } else {
            if (this.type == ShapeType.RECTANGLE_HTML_FOR_PORTS) {
                throw new UnsupportedOperationException();
            }
            if (this.type == ShapeType.OCTAGON) {
                stringBuilder.append("shape=octagon");
            } else if (this.type == ShapeType.DIAMOND) {
                stringBuilder.append("shape=diamond");
            } else if (this.type == ShapeType.CIRCLE) {
                stringBuilder.append("shape=circle");
            } else if (this.type == ShapeType.CIRCLE_IN_RECT) {
                stringBuilder.append("shape=circle");
            } else if (this.type == ShapeType.OVAL) {
                stringBuilder.append("shape=ellipse");
            } else if (this.type == ShapeType.ROUND_RECTANGLE) {
                stringBuilder.append("shape=rect,style=rounded");
            } else {
                throw new IllegalStateException(this.type.toString());
            }
        }
    }

    @Override
    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    public final boolean isTop() {
        return this.top;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.minX, this.minY);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
    }

    public boolean isShielded() {
        return !this.shield.isZero();
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.minX += d;
        this.minY += d2;
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        EntityImageStateBorder entityImageStateBorder = (EntityImageStateBorder)this.image;
        return entityImageStateBorder.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    @Override
    public boolean isHidden() {
        return this.image.isHidden();
    }

    public void setOctagon(double d, double d2, List<Point2D.Double> list) {
        this.octagon = new UPolygon(list).translate(-d, -d2);
    }

    public Shadowable getOctagon() {
        return this.octagon;
    }

    public Point2D getPoint2D(double d, double d2) {
        return new Point2D.Double(this.minX + d, this.minY + d2);
    }

    public Point2D projection(Point2D point2D, StringBounder stringBounder) {
        if (this.getType() != ShapeType.FOLDER) {
            return point2D;
        }
        ClusterPosition clusterPosition = new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
        if (clusterPosition.isPointJustUpper(point2D)) {
            Dimension2D dimension2D = ((EntityImageDescription)this.image).getNameDimension(stringBounder);
            if (point2D.getX() < this.minX + dimension2D.getWidth()) {
                return point2D;
            }
            return new Point2D.Double(point2D.getX(), point2D.getY() + dimension2D.getHeight() + 4.0);
        }
        return point2D;
    }
}

