/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.NamedOutputStream;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotDataImageBuilder;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;

    public CucaDiagramFileMakerSvek(CucaDiagram cucaDiagram) throws IOException {
        this.diagram = cucaDiagram;
    }

    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(outputStream, list, fileFormatOption);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new IOException(interruptedException);
        }
    }

    private DotDataImageBuilder createDotDataImageBuilder(DotMode dotMode, StringBounder stringBounder) {
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafsvalues(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), dotMode, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        return new DotDataImageBuilder(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), stringBounder);
    }

    private ImageData createFileInternal(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        TextBlockBackcolored textBlockBackcolored;
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, list, fileFormatOption.getDefaultStringBounder());
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, list, fileFormatOption.getDefaultStringBounder());
        }
        DotDataImageBuilder dotDataImageBuilder = this.createDotDataImageBuilder(DotMode.NORMAL, fileFormatOption.getDefaultStringBounder());
        BaseFile baseFile = null;
        if (fileFormatOption.isDebugSvek() && outputStream instanceof NamedOutputStream) {
            baseFile = ((NamedOutputStream)outputStream).getBasefile();
        }
        if ((textBlockBackcolored = dotDataImageBuilder.buildImage(baseFile, this.diagram.getDotStringSkek())) instanceof GraphvizCrash) {
            dotDataImageBuilder = this.createDotDataImageBuilder(DotMode.NO_LEFT_RIGHT_AND_XLABEL, fileFormatOption.getDefaultStringBounder());
            textBlockBackcolored = dotDataImageBuilder.buildImage(baseFile, this.diagram.getDotStringSkek());
        }
        textBlockBackcolored = new AnnotatedWorker(this.diagram, this.diagram.getSkinParam()).addAdd(textBlockBackcolored);
        String string = this.diagram.getSkinParam().getValue("widthwarning");
        String string2 = null;
        if (string != null && string.matches("\\d+")) {
            string2 = dotDataImageBuilder.getWarningOrError(Integer.parseInt(string));
        }
        Dimension2D dimension2D = textBlockBackcolored.calculateDimension(fileFormatOption.getDefaultStringBounder());
        double d = this.getScale(fileFormatOption, dimension2D);
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam(), d, fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null, string2, 0.0, 10.0, this.diagram.getAnimation(), textBlockBackcolored.getBackcolor());
        imageBuilder.setUDrawable(textBlockBackcolored);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.diagram.seed(), outputStream);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            this.addLinkNew(arrayList, link);
        }
        return arrayList;
    }

    private void addLinkNew(List<Link> list, Link link) {
        for (int i = 0; i < list.size(); ++i) {
            Link link2 = list.get(i);
            if (!link2.sameConnections(link)) continue;
            while (i < list.size() && list.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == list.size()) {
                list.add(link);
            } else {
                list.add(i, link);
            }
            return;
        }
        list.add(link);
    }

    private double getScale(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        Scale scale = this.diagram.getScale();
        double d = scale == null ? this.diagram.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        return d;
    }
}

