/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.api.NumberAnalyzed;
import net.sourceforge.plantuml.stats.StatsLineImpl;
import net.sourceforge.plantuml.stats.StatsTableImpl;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

public class FormatCounter {
    private ConcurrentMap<FileFormat, NumberAnalyzed> data = new ConcurrentHashMap<FileFormat, NumberAnalyzed>();

    public FormatCounter(String string) {
        for (FileFormat fileFormat : FileFormat.values()) {
            String string2 = string + fileFormat.name();
            this.data.put(fileFormat, new NumberAnalyzed(string2));
        }
    }

    public void plusOne(FileFormat fileFormat, long l) {
        NumberAnalyzed numberAnalyzed = (NumberAnalyzed)this.data.get((Object)fileFormat);
        numberAnalyzed.addValue(l);
    }

    private StatsLine createLine(String string, NumberAnalyzed numberAnalyzed) {
        EnumMap<StatsColumn, Object> enumMap = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        enumMap.put(StatsColumn.FORMAT, string);
        enumMap.put(StatsColumn.GENERATED_COUNT, Long.valueOf(numberAnalyzed.getNb()));
        enumMap.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(numberAnalyzed.getMean()));
        enumMap.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(numberAnalyzed.getStandardDeviation()));
        enumMap.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(numberAnalyzed.getMax()));
        return new StatsLineImpl(enumMap);
    }

    public StatsTable getStatsTable(String string) {
        StatsTableImpl statsTableImpl = new StatsTableImpl(string);
        NumberAnalyzed numberAnalyzed = new NumberAnalyzed();
        for (Map.Entry entry : this.data.entrySet()) {
            NumberAnalyzed numberAnalyzed2 = (NumberAnalyzed)entry.getValue();
            if (numberAnalyzed2.getNb() <= 0L) continue;
            statsTableImpl.addLine(this.createLine(((FileFormat)((Object)entry.getKey())).name(), numberAnalyzed2));
            numberAnalyzed.add(numberAnalyzed2);
        }
        statsTableImpl.addLine(this.createLine("Total", numberAnalyzed));
        return statsTableImpl;
    }

    public void reload(String string, Preferences preferences) throws BackingStoreException {
        for (String string2 : preferences.keys()) {
            if (!string2.startsWith(string)) continue;
            try {
                String string3 = FormatCounter.removeDotSaved(string2);
                NumberAnalyzed numberAnalyzed = NumberAnalyzed.load(string3, preferences);
                if (numberAnalyzed == null) continue;
                FileFormat fileFormat = FileFormat.valueOf(string3.substring(string.length()));
                this.data.put(fileFormat, numberAnalyzed);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static String removeDotSaved(String string) {
        return string.substring(0, string.length() - ".saved".length());
    }

    public void save(Preferences preferences, FileFormat fileFormat) {
        ((NumberAnalyzed)this.data.get((Object)fileFormat)).save(preferences);
    }
}

