/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class StateDiagram
extends AbstractEntityDiagram {
    private static final String CONCURRENT_PREFIX = "CONC";
    private boolean hideEmptyDescription = false;

    public boolean checkConcurrentStateOk(Code code) {
        if (!this.leafExist(code)) {
            return true;
        }
        ILeaf iLeaf = this.getLeafsget(code);
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != iLeaf.getParentContainer()) {
            return false;
        }
        return iLeaf.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == iLeaf.getParentContainer();
    }

    public IEntity getOrCreateLeaf(Code code, LeafType leafType, USymbol uSymbol) {
        if (!this.checkConcurrentStateOk(code)) {
            throw new IllegalStateException("Concurrent State " + code);
        }
        if (leafType == null) {
            if (code.getFullName().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroup(code)) {
                return this.getGroup(code);
            }
            return this.getOrCreateLeafDefault(code, LeafType.STATE, null);
        }
        return this.getOrCreateLeafDefault(code, leafType, uSymbol);
    }

    public IEntity getStart() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*start"), LeafType.CIRCLE_START, null);
        }
        return this.getOrCreateLeaf(Code.of("*start*" + iGroup.getCode().getFullName()), LeafType.CIRCLE_START, null);
    }

    public IEntity getEnd() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*end"), LeafType.CIRCLE_END, null);
        }
        return this.getOrCreateLeaf(Code.of("*end*" + iGroup.getCode().getFullName()), LeafType.CIRCLE_END, null);
    }

    public IEntity getHistorical() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*historical"), LeafType.PSEUDO_STATE, null);
        }
        return this.getOrCreateLeaf(Code.of("*historical*" + iGroup.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
    }

    public IEntity getHistorical(Code code) {
        IGroup iGroup = this.getOrCreateGroup(code, Display.getWithNewlines(code), GroupType.STATE, this.getRootGroup());
        IEntity iEntity = this.getOrCreateLeaf(Code.of("*historical*" + iGroup.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
        this.endGroup();
        return iEntity;
    }

    public boolean concurrentState(char c) {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        this.getCurrentGroup().setConcurrentSeparator(c);
        IGroup iGroup2 = this.getOrCreateGroup(UniqueSequence.getCode(CONCURRENT_PREFIX), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.STATE) {
            iGroup.moveEntitiesTo(iGroup2);
            super.endGroup();
            this.getOrCreateGroup(UniqueSequence.getCode(CONCURRENT_PREFIX), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        }
        return true;
    }

    public void endGroup() {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.hideEmptyDescription;
    }

    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            IGroup iGroup;
            IGroup iGroup2 = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity1());
            if (StateDiagram.isCompatible(iGroup2, iGroup = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity2()))) continue;
            return "State within concurrent state cannot be linked out of this concurrent state (between " + link.getEntity1().getCode().getFullName() + " and " + link.getEntity2().getCode().getFullName() + ")";
        }
        return super.checkFinalError();
    }

    private static boolean isCompatible(IGroup iGroup, IGroup iGroup2) {
        if (iGroup == null && iGroup2 == null) {
            return true;
        }
        if (iGroup != null ^ iGroup2 != null) {
            return false;
        }
        assert (iGroup != null && iGroup2 != null);
        return iGroup == iGroup2;
    }

    private static IGroup getGroupParentIfItIsConcurrentState(IEntity iEntity) {
        for (IGroup iGroup = iEntity.getParentContainer(); iGroup != null; iGroup = iGroup.getParentContainer()) {
            if (iGroup.getGroupType() != GroupType.CONCURRENT_STATE) continue;
            return iGroup;
        }
        return null;
    }
}

