/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNoteBox
extends AbstractTextualComponent {
    private final SymbolContext symbolContext;

    public ComponentRoseNoteBox(SymbolContext symbolContext, FontConfiguration fontConfiguration, Display display, ISkinSimple iSkinSimple) {
        super(LineBreakStrategy.NONE, display, fontConfiguration, HorizontalAlignment.LEFT, 4, 4, 4, iSkinSimple, false, null, null);
        this.symbolContext = symbolContext;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    public double getPaddingX() {
        return 5.0;
    }

    public double getPaddingY() {
        return 5.0;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        double d = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            n2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        uGraphic = this.symbolContext.apply(uGraphic);
        URectangle uRectangle = new URectangle(n2, n);
        uRectangle.setDeltaShadow(this.symbolContext.getDeltaShadow());
        uGraphic.draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate((double)this.getMarginX1() + d / 2.0, this.getMarginY())));
    }
}

