/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutingLine {
    private final Skin skin;
    private final ISkinParam skinParam;
    private final boolean useContinueLineBecauseOfDelay;
    private final Map<Double, Double> delays = new TreeMap<Double, Double>();

    public MutingLine(Skin skin, ISkinParam iSkinParam, List<Event> list) {
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.useContinueLineBecauseOfDelay = this.useContinueLineBecauseOfDelay(list);
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> list) {
        String string = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(string)) {
            return false;
        }
        for (Event event : list) {
            if (!(event instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLine(UGraphic uGraphic, Context2D context2D, double d, double d2) {
        ComponentType componentType;
        ComponentType componentType2 = componentType = this.useContinueLineBecauseOfDelay ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        if (this.delays.size() > 0) {
            double d3 = d;
            for (Map.Entry<Double, Double> entry : this.delays.entrySet()) {
                if (!(entry.getKey() >= d)) continue;
                this.drawInternal(uGraphic, context2D, d3, entry.getKey(), componentType);
                this.drawInternal(uGraphic, context2D, entry.getKey(), entry.getKey() + entry.getValue(), ComponentType.DELAY_LINE);
                d3 = entry.getKey() + entry.getValue();
            }
            this.drawInternal(uGraphic, context2D, d3, d2, componentType);
        } else {
            this.drawInternal(uGraphic, context2D, d, d2, componentType);
        }
    }

    private void drawInternal(UGraphic uGraphic, Context2D context2D, double d, double d2, ComponentType componentType) {
        if (d2 == d) {
            return;
        }
        if (d2 < d) {
            throw new IllegalArgumentException();
        }
        Component component = this.skin.createComponent(componentType, null, this.skinParam, null);
        Dimension2D dimension2D = component.getPreferredDimension(uGraphic.getStringBounder());
        Area area = new Area(dimension2D.getWidth(), d2 - d);
        component.drawU(uGraphic.apply(new UTranslate(0.0, d)), area, context2D);
    }

    public void delayOn(double d, double d2) {
        this.delays.put(d, d2);
    }
}

