/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrow() {
        super(CommandArrow.getRegexConcat());
    }

    public static String getColorOrStylePattern() {
        return "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden)*)\\])?";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PARALLEL", "(&%s*)?"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART1LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW_DRESSING1", "([%s][ox]|(?:[%s][ox])?<<?|(?:[%s][ox])?//?|(?:[%s][ox])?\\\\\\\\?)?"), new RegexOr(new RegexConcat(new RegexLeaf("ARROW_BODYA1", "(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB1", "(-*)")), new RegexConcat(new RegexLeaf("ARROW_BODYA2", "(-*)"), new RegexLeaf("ARROW_STYLE2", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB2", "(-+)"))), new RegexLeaf("ARROW_DRESSING2", "(>>?(?:[ox][%s])?|//?(?:[ox][%s])?|\\\\\\\\?(?:[ox][%s])?|[ox][%s])?"), new RegexLeaf("[%s]*"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART2LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*"), new RegexLeaf("ACTIVATION", "(?:([+*!-]+)?)"), new RegexLeaf("[%s]*"), new RegexLeaf("LIFECOLOR", "(?:(#\\w+)?)"), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?$"));
    }

    private Participant getOrCreateParticipant(SequenceDiagram sequenceDiagram, RegexResult regexResult, String string) {
        Display display;
        String string2;
        if (regexResult.get(string + "CODE", 0) != null) {
            string2 = regexResult.get(string + "CODE", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONG", 0) != null) {
            string2 = regexResult.get(string + "LONG", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONGCODE", 0) != null) {
            display = Display.getWithNewlines(regexResult.get(string + "LONGCODE", 0));
            string2 = regexResult.get(string + "LONGCODE", 1);
        } else {
            if (regexResult.get(string + "CODELONG", 0) != null) {
                String string3 = regexResult.get(string + "CODELONG", 0);
                Display display2 = Display.getWithNewlines(regexResult.get(string + "CODELONG", 1));
                return sequenceDiagram.getOrCreateParticipant(string3, display2);
            }
            throw new IllegalStateException();
        }
        return sequenceDiagram.getOrCreateParticipant(string2, display);
    }

    private boolean contains(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        boolean bl;
        Object object;
        Object object2;
        Display display;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Participant participant;
        Participant participant2;
        String string = StringUtils.goLowerCase(CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING1", 0)));
        String string2 = StringUtils.goLowerCase(CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING2", 0)));
        boolean bl5 = this.contains(string2, ">", "\\", "/", "x");
        boolean bl6 = this.contains(string, "x", "<", "\\", "/");
        if (bl5) {
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl4 = string.contains("o");
            bl3 = string2.contains("o");
        } else if (bl6) {
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl4 = string2.contains("o");
            bl3 = string.contains("o");
        } else {
            return CommandExecutionResult.error("Illegal sequence arrow");
        }
        boolean bl7 = this.contains(string, "<<", "\\\\", "//") || this.contains(string2, ">>", "\\\\", "//");
        boolean bl8 = bl2 = this.getLength(regexResult) > 1;
        if (regexResult.get("MESSAGE", 0) == null) {
            display = Display.create("");
        } else {
            object2 = regexResult.get("MESSAGE", 0);
            display = Display.getWithNewlines((String)object2);
        }
        Object object3 = object2 = bl6 && bl5 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (bl2) {
            object2 = ((ArrowConfiguration)object2).withBody(ArrowBody.DOTTED);
        }
        if (bl7) {
            object2 = ((ArrowConfiguration)object2).withHead(ArrowHead.ASYNC);
        }
        if (string2.contains("\\") || string.contains("/")) {
            object2 = ((ArrowConfiguration)object2).withPart(ArrowPart.TOP_PART);
        }
        if (string2.contains("/") || string.contains("\\")) {
            object2 = ((ArrowConfiguration)object2).withPart(ArrowPart.BOTTOM_PART);
        }
        if (bl3) {
            object2 = ((ArrowConfiguration)object2).withDecoration2(ArrowDecoration.CIRCLE);
        }
        if (bl4) {
            object2 = ((ArrowConfiguration)object2).withDecoration1(ArrowDecoration.CIRCLE);
        }
        if (string.contains("x")) {
            object2 = ((ArrowConfiguration)object2).withHead2(ArrowHead.CROSSX);
        }
        if (string2.contains("x")) {
            object2 = ((ArrowConfiguration)object2).withHead2(ArrowHead.CROSSX);
        }
        object2 = CommandArrow.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), (ArrowConfiguration)object2);
        String string3 = regexResult.get("ACTIVATION", 0);
        if (string3 != null && string3.charAt(0) == '*') {
            sequenceDiagram.activate(participant, LifeEventType.CREATE, null);
        }
        Message message = new Message(participant2, participant, display, (ArrowConfiguration)object2, sequenceDiagram.getNextMessageNumber());
        if (regexResult.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = urlBuilder.getUrl(regexResult.get("URL", 0));
            message.setUrl((Url)object);
        }
        boolean bl9 = bl = regexResult.get("PARALLEL", 0) != null;
        if (bl) {
            message.goParallel();
        }
        if ((object = sequenceDiagram.addMessage(message)) != null) {
            return CommandExecutionResult.error((String)object);
        }
        HtmlColor htmlColor = sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LIFECOLOR", 0));
        if (string3 != null) {
            switch (string3.charAt(0)) {
                case '+': {
                    sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
                    break;
                }
                case '-': {
                    sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
                    break;
                }
                case '!': {
                    sequenceDiagram.activate(participant, LifeEventType.DESTROY, null);
                    break;
                }
            }
        } else if (sequenceDiagram.isAutoactivate() && (((ArrowConfiguration)object2).getHead() == ArrowHead.NORMAL || ((ArrowConfiguration)object2).getHead() == ArrowHead.ASYNC)) {
            if (((ArrowConfiguration)object2).isDotted()) {
                sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
            } else {
                sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private int getLength(RegexResult regexResult) {
        String string;
        String string2 = regexResult.getLazzy("ARROW_BODYA", 0);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = regexResult.getLazzy("ARROW_BODYB", 0)) == null) {
            string = "";
        }
        return string2.length() + string.length();
    }

    public static ArrowConfiguration applyStyle(String string, ArrowConfiguration arrowConfiguration) {
        if (string == null) {
            return arrowConfiguration;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed")) {
                arrowConfiguration = arrowConfiguration.withBody(ArrowBody.DOTTED);
                continue;
            }
            if (string2.equalsIgnoreCase("bold")) continue;
            if (string2.equalsIgnoreCase("dotted")) {
                arrowConfiguration = arrowConfiguration.withBody(ArrowBody.DOTTED);
                continue;
            }
            if (string2.equalsIgnoreCase("hidden")) {
                arrowConfiguration = arrowConfiguration.withBody(ArrowBody.HIDDEN);
                continue;
            }
            arrowConfiguration = arrowConfiguration.withColor(HtmlColorSet.getInstance().getColorIfValid(string2));
        }
        return arrowConfiguration;
    }
}

