/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalCommandAnd
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern1;
    private final ComplementPattern complementPattern1;
    private final VerbPattern verbPattern2;
    private final ComplementPattern complementPattern2;

    private NaturalCommandAnd(RegexConcat regexConcat, SubjectPattern subjectPattern, VerbPattern verbPattern, ComplementPattern complementPattern, VerbPattern verbPattern2, ComplementPattern complementPattern2) {
        super(regexConcat);
        this.subjectPattern = subjectPattern;
        this.verbPattern1 = verbPattern;
        this.complementPattern1 = complementPattern;
        this.verbPattern2 = verbPattern2;
        this.complementPattern2 = complementPattern2;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern1.toString() + " " + this.complementPattern1.toString() + " and " + this.verbPattern2.toString() + " " + this.complementPattern2.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram ganttDiagram, RegexResult regexResult) {
        Subject subject = this.subjectPattern.getSubject(ganttDiagram, regexResult);
        Verb verb = this.verbPattern1.getVerb(ganttDiagram, regexResult);
        Failable<Complement> failable = this.complementPattern1.getComplement(ganttDiagram, regexResult, "1");
        if (failable.isFail()) {
            return CommandExecutionResult.error(failable.getError());
        }
        CommandExecutionResult commandExecutionResult = verb.execute(subject, failable.get());
        if (!commandExecutionResult.isOk()) {
            return commandExecutionResult;
        }
        Verb verb2 = this.verbPattern2.getVerb(ganttDiagram, regexResult);
        Failable<Complement> failable2 = this.complementPattern2.getComplement(ganttDiagram, regexResult, "2");
        if (failable2.isFail()) {
            return CommandExecutionResult.error(failable2.getError());
        }
        return verb2.execute(subject, failable2.get());
    }

    public static Command create(SubjectPattern subjectPattern, VerbPattern verbPattern, ComplementPattern complementPattern, VerbPattern verbPattern2, ComplementPattern complementPattern2) {
        RegexConcat regexConcat = new RegexConcat(new RegexLeaf("^"), subjectPattern.toRegex(), new RegexLeaf("[%s]+"), verbPattern.toRegex(), new RegexLeaf("[%s]+"), complementPattern.toRegex("1"), new RegexLeaf("[%s]+"), new RegexLeaf("and"), new RegexLeaf("[%s]+"), verbPattern2.toRegex(), new RegexLeaf("[%s]+"), complementPattern2.toRegex("2"), new RegexLeaf("$"));
        return new NaturalCommandAnd(regexConcat, subjectPattern, verbPattern, complementPattern, verbPattern2, complementPattern2);
    }
}

