/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalCommand
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern;
    private final ComplementPattern complementPattern;

    private NaturalCommand(RegexConcat regexConcat, SubjectPattern subjectPattern, VerbPattern verbPattern, ComplementPattern complementPattern) {
        super(regexConcat);
        this.subjectPattern = subjectPattern;
        this.verbPattern = verbPattern;
        this.complementPattern = complementPattern;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern.toString() + " " + this.complementPattern.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram ganttDiagram, RegexResult regexResult) {
        Subject subject = this.subjectPattern.getSubject(ganttDiagram, regexResult);
        Verb verb = this.verbPattern.getVerb(ganttDiagram, regexResult);
        Failable<Complement> failable = this.complementPattern.getComplement(ganttDiagram, regexResult, "0");
        if (failable.isFail()) {
            return CommandExecutionResult.error(failable.getError());
        }
        return verb.execute(subject, failable.get());
    }

    public static Command create(SubjectPattern subjectPattern, VerbPattern verbPattern, ComplementPattern complementPattern) {
        return new NaturalCommand(new RegexConcat(new RegexLeaf("^"), subjectPattern.toRegex(), new RegexLeaf("[%s]+"), verbPattern.toRegex(), new RegexLeaf("[%s]+"), complementPattern.toRegex("0"), new RegexLeaf("$")), subjectPattern, verbPattern, complementPattern);
    }
}

