/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.project.BasicInstantArithmetic;
import net.sourceforge.plantuml.project.Constant;
import net.sourceforge.plantuml.project.Day;
import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.DayCloseOr;
import net.sourceforge.plantuml.project.DayCloseWeekDay;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Expression;
import net.sourceforge.plantuml.project.FormalAddition;
import net.sourceforge.plantuml.project.FormalAdditionInstantDuration;
import net.sourceforge.plantuml.project.FreeVariable;
import net.sourceforge.plantuml.project.IncompleteItem;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.ItemCaract;
import net.sourceforge.plantuml.project.ItemComparator;
import net.sourceforge.plantuml.project.Jalon;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;
import net.sourceforge.plantuml.project.ParentItem;
import net.sourceforge.plantuml.project.Ressource;
import net.sourceforge.plantuml.project.WeekDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private final Map<String, FreeVariable> variables = new TreeMap<String, FreeVariable>();
    private final Map<String, Item> items = new TreeMap<String, Item>();
    private final Map<String, Ressource> ressources = new TreeMap<String, Ressource>();
    private final DayCloseOr dayClose = new DayCloseOr();

    public final Instant getStart() {
        Instant instant = null;
        for (Item item2 : this.getValidItems()) {
            if (instant != null && instant.compareTo(item2.getBegin()) <= 0) continue;
            instant = item2.getBegin();
        }
        return instant;
    }

    public final Instant getEnd() {
        Instant instant = null;
        for (Item item2 : this.getValidItems()) {
            if (instant != null && instant.compareTo(item2.getCompleted()) >= 0) continue;
            instant = item2.getCompleted();
        }
        return instant;
    }

    public FreeVariable createVariable(String string, NumericType numericType) {
        if (this.variables.containsKey(string)) {
            throw new IllegalArgumentException("Already exist: " + string);
        }
        FreeVariable freeVariable = new FreeVariable(string, numericType);
        this.variables.put(string, freeVariable);
        return freeVariable;
    }

    public Expression getExpression(String string) {
        int n = (string = StringUtils.trin(string)).indexOf(43);
        if (n != -1) {
            Expression expression = this.getExpression(string.substring(0, n));
            Expression expression2 = this.getExpression(string.substring(n + 1));
            if (expression.getNumericType() == NumericType.INSTANT && (expression2.getNumericType() == NumericType.DURATION || expression2.getNumericType() == NumericType.NUMBER)) {
                return new FormalAdditionInstantDuration(expression, expression2, new BasicInstantArithmetic(this.dayClose));
            }
            if (expression2.getNumericType() == NumericType.INSTANT && (expression.getNumericType() == NumericType.DURATION || expression.getNumericType() == NumericType.NUMBER)) {
                return new FormalAdditionInstantDuration(expression2, expression, new BasicInstantArithmetic(this.dayClose));
            }
            return new FormalAddition(expression, expression2);
        }
        if (string.matches("^\\d+$")) {
            return new Constant(new NumericNumber(Integer.parseInt(string)));
        }
        if (string.matches("^\\$\\w+$")) {
            String string2 = string.substring(1);
            FreeVariable freeVariable = this.variables.get(string2);
            if (freeVariable != null) {
                return freeVariable;
            }
            throw new IllegalArgumentException("No such variable: " + string);
        }
        if (Day.isValidDesc(string)) {
            Day day = new Day(string);
            return new Constant(new Instant(day));
        }
        if (string.matches("^[\\w/]+\\$(begin|completed|work|load|duration)$")) {
            int n2 = string.indexOf(36);
            String string3 = string.substring(0, n2);
            Item item2 = this.items.get(string3);
            if (item2 == null) {
                throw new IllegalArgumentException("No such variable: " + string);
            }
            return new Constant(ItemCaract.valueOf(StringUtils.goUpperCase(string.substring(n2 + 1))).getData(item2));
        }
        if (string.startsWith("^")) {
            Item item3 = this.items.get(string.substring(1));
            if (item3 == null) {
                throw new IllegalArgumentException("No such variable: " + string);
            }
            return new Constant(item3.getBegin());
        }
        throw new IllegalArgumentException("cannot parse");
    }

    public boolean affectation(String string, Expression expression) {
        if (string.startsWith("^")) {
            return this.affectationJalon(string, expression);
        }
        if (string.startsWith("~")) {
            return this.affectationRessource(string, expression);
        }
        int n = string.indexOf(36);
        if (n == -1) {
            return this.affectationVariable(string, expression);
        }
        String string2 = string.substring(0, n);
        Item item2 = this.getItem(string2);
        if (!(item2 instanceof IncompleteItem)) {
            return false;
        }
        IncompleteItem incompleteItem = (IncompleteItem)item2;
        String string3 = string.substring(n + 1);
        if (string3.equalsIgnoreCase("begin")) {
            incompleteItem.setData(ItemCaract.BEGIN, expression.getValue());
        } else if (string3.equalsIgnoreCase("completed")) {
            incompleteItem.setData(ItemCaract.COMPLETED, expression.getValue());
        } else if (string3.equalsIgnoreCase("work")) {
            incompleteItem.setData(ItemCaract.WORK, expression.getValue());
        } else if (string3.equalsIgnoreCase("duration")) {
            if (expression.getNumericType() == NumericType.NUMBER) {
                expression = new Constant(new Duration((NumericNumber)expression.getValue()));
            }
            incompleteItem.setData(ItemCaract.DURATION, expression.getValue());
        } else if (string3.equalsIgnoreCase("LOAD")) {
            if (expression.getNumericType() == NumericType.NUMBER) {
                expression = new Constant(new Load((NumericNumber)expression.getValue()));
            }
            incompleteItem.setData(ItemCaract.LOAD, expression.getValue());
        } else {
            return false;
        }
        return true;
    }

    private boolean affectationRessource(String string, Expression expression) {
        int n;
        String string2 = (string = string.substring(1)).substring((n = string.indexOf(36)) + 1);
        if (string2.equals("capacity")) {
            Ressource ressource = this.getRessource(string.substring(0, n));
            ressource.setCapacity(((NumericNumber)expression.getValue()).getIntValue());
            return true;
        }
        return false;
    }

    private Ressource getRessource(String string) {
        Ressource ressource = this.ressources.get(string);
        if (ressource == null) {
            ressource = new Ressource(string);
            this.ressources.put(string, ressource);
        }
        return ressource;
    }

    private boolean affectationJalon(String string, Expression expression) {
        Jalon jalon = this.getItemJalon(string.substring(1));
        jalon.setInstant(expression.getValue());
        return true;
    }

    private Jalon getItemJalon(String string) {
        Jalon jalon = (Jalon)this.items.get(string);
        if (jalon == null) {
            jalon = new Jalon(string, null);
            this.items.put(string, jalon);
        }
        return jalon;
    }

    private Item getItem(String string) {
        Item item2 = this.items.get(string);
        if (item2 == null) {
            int n = string.indexOf(47);
            if (n == -1) {
                item2 = new IncompleteItem(string, null, new BasicInstantArithmetic(this.dayClose));
            } else {
                ParentItem parentItem = this.getItemParent(string.substring(0, n));
                item2 = new IncompleteItem(string, parentItem, new BasicInstantArithmetic(this.dayClose));
                parentItem.addChild(item2);
            }
            this.items.put(string, item2);
        }
        return item2;
    }

    private ParentItem getItemParent(String string) {
        Item item2 = this.items.get(string);
        if (item2 == null) {
            int n = string.indexOf(47);
            if (n == -1) {
                item2 = new ParentItem(string, null);
                this.items.put(string, item2);
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return (ParentItem)item2;
    }

    private boolean affectationVariable(String string, Expression expression) {
        if (!this.variables.containsKey(string)) {
            return false;
        }
        this.variables.get(string).setValue(expression);
        return true;
    }

    public List<Item> getValidItems() {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Item item2 : this.items.values()) {
            if (!item2.isValid()) continue;
            arrayList.add(item2);
        }
        Collections.sort(arrayList, new ItemComparator());
        return Collections.unmodifiableList(arrayList);
    }

    public final DayClose getDayClose() {
        return this.dayClose;
    }

    public void closeWeekDay(WeekDay weekDay) {
        this.dayClose.add(new DayCloseWeekDay(weekDay));
    }
}

