/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.preproc.DefineVariable;

public class Variables {
    private final List<DefineVariable> all = new ArrayList<DefineVariable>();

    public void add(DefineVariable defineVariable) {
        this.all.add(defineVariable);
    }

    public int countDefaultValue() {
        int n = 0;
        for (DefineVariable defineVariable : this.all) {
            if (defineVariable.getDefaultValue() == null) continue;
            ++n;
        }
        return n;
    }

    public Variables removeSomeDefaultValues(int n) {
        if (n == 0) {
            return this;
        }
        Variables variables = new Variables();
        for (DefineVariable defineVariable : this.all) {
            if (defineVariable.getDefaultValue() != null && n > 0) {
                variables.add(defineVariable.removeDefault());
                --n;
                continue;
            }
            variables.add(defineVariable);
        }
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return variables;
    }

    public String applyOn(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("\\b" + string2 + "\\(");
        List<DefineVariable> list = this.all;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            DefineVariable defineVariable = list.get(i);
            String string4 = defineVariable.getName();
            String string5 = "(##" + string4 + "\\b)|(\\b" + string4 + "##)|(\\b" + string4 + "\\b)";
            if (defineVariable.getDefaultValue() == null) {
                stringBuilder.append("(?:(?:\\s*\"([^\"]*)\"\\s*)|(?:\\s*'([^']*)'\\s*)|\\s*((?:\\([^()]*\\)|[^,'\"])*?))");
                int n = 1 + 3 * i;
                string3 = string3.replaceAll(string5, "\\$" + n + "\\$" + (n + 1) + "\\$" + (n + 2));
                stringBuilder.append(",");
                bl = true;
                continue;
            }
            string3 = string3.replaceAll(string5, Matcher.quoteReplacement(defineVariable.getDefaultValue()));
        }
        if (bl) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append("\\)");
        string = string.replaceAll(stringBuilder.toString(), string3);
        return string;
    }
}

