/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityObjectMultilines
extends CommandMultilines2<AbstractClassOrObjectDiagram> {
    public CommandCreateEntityObjectMultilines() {
        super(CommandCreateEntityObjectMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(object)[%s]+"), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*\\{[%s]*$"));
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\}[%s]*$";
    }

    @Override
    public CommandExecutionResult executeNow(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, BlocLines blocLines) {
        blocLines = blocLines.trim(true);
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        IEntity iEntity = this.executeArg0(abstractClassOrObjectDiagram, regexResult);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        blocLines = blocLines.subExtract(1, 1);
        for (CharSequence charSequence : blocLines) {
            assert (charSequence.length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(charSequence)) {
                abstractClassOrObjectDiagram.setVisibilityModifierPresent(true);
            }
            iEntity.getBodier().addFieldOrMethod(charSequence.toString(), iEntity);
        }
        return CommandExecutionResult.ok();
    }

    private IEntity executeArg0(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Code code = Code.of(regexResult.get("NAME", 1));
        String string = regexResult.get("NAME", 0);
        String string2 = regexResult.get("STEREO", 0);
        if (abstractClassOrObjectDiagram.leafExist(code)) {
            return abstractClassOrObjectDiagram.getOrCreateLeaf(code, LeafType.OBJECT, null);
        }
        ILeaf iLeaf = abstractClassOrObjectDiagram.createLeaf(code, Display.getWithNewlines(string), LeafType.OBJECT, null);
        if (string2 != null) {
            iLeaf.setStereotype(new Stereotype(string2, abstractClassOrObjectDiagram.getSkinParam().getCircledCharacterRadius(), abstractClassOrObjectDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet()));
        }
        iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return iLeaf;
    }
}

