/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SvgString;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.math.AsciiMath;
import net.sourceforge.plantuml.math.LatexBuilder;
import net.sourceforge.plantuml.math.ScientificEquation;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ScientificEquationSafe {
    private final ScientificEquation equation;
    private final String formula;
    private ImageData dimSvg;

    private ScientificEquationSafe(String string, ScientificEquation scientificEquation) {
        this.formula = string;
        this.equation = scientificEquation;
    }

    public static ScientificEquationSafe fromAsciiMath(String string) {
        try {
            return new ScientificEquationSafe(string, new AsciiMath(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.info("Error parsing " + string);
            return new ScientificEquationSafe(string, null);
        }
    }

    public static ScientificEquationSafe fromLatex(String string) {
        try {
            return new ScientificEquationSafe(string, new LatexBuilder(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.info("Error parsing " + string);
            return new ScientificEquationSafe(string, null);
        }
    }

    public SvgString getSvg(double d, Color color, Color color2) {
        try {
            SvgString svgString = this.equation.getSvg(d, color, color2);
            this.dimSvg = new ImageDataSimple(this.equation.getDimension());
            return svgString;
        }
        catch (Exception exception) {
            this.printTrace(exception);
            ImageBuilder imageBuilder = this.getRollback();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.dimSvg = imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.SVG), 42L, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                return null;
            }
            return new SvgString(new String(byteArrayOutputStream.toByteArray()), d);
        }
    }

    public BufferedImage getImage(double d, Color color, Color color2) {
        try {
            return this.equation.getImage(d, color, color2);
        }
        catch (Exception exception) {
            this.printTrace(exception);
            ImageBuilder imageBuilder = this.getRollback();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), 42L, byteArrayOutputStream);
                return ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    private void printTrace(Exception exception) {
        System.err.println("formula=" + this.formula);
        if (this.formula != null) {
            System.err.println("Latex=" + this.equation.getSource());
        }
        exception.printStackTrace();
    }

    private ImageBuilder getRollback() {
        TextBlockBackcolored textBlockBackcolored = GraphicStrings.createBlackOnWhiteMonospaced(Arrays.asList(this.formula));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(textBlockBackcolored);
        return imageBuilder;
    }

    public ImageData export(OutputStream outputStream, FileFormatOption fileFormatOption, float f, Color color, Color color2) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            BufferedImage bufferedImage = this.getImage(f, color, color2);
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            return new ImageDataSimple(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        if (fileFormatOption.getFileFormat() == FileFormat.SVG) {
            outputStream.write(this.getSvg(1.0, color, color2).getSvg().getBytes());
            return this.dimSvg;
        }
        return null;
    }
}

