/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.plantuml.Dimension2DDouble;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AsciiMathOld {
    private static final String ASCIIMATH_PARSER_JS_LOCATION = "/net/sourceforge/plantuml/math/";
    private static String JAVASCRIPT_CODE;
    private final Node mathML;
    private Dimension2D dim;

    public AsciiMathOld(String string) throws IOException, ScriptException, ParserConfigurationException, NoSuchMethodException {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        scriptEngine.eval(JAVASCRIPT_CODE);
        Invocable invocable = (Invocable)((Object)scriptEngine);
        Document document = this.createDocument();
        this.mathML = (Node)invocable.invokeFunction("plantuml", document, string);
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return document;
    }

    public String getSvg() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Class<?> clazz = Class.forName("net.sourceforge.jeuclid.converter.Converter");
        Method method = clazz.getMethod("getInstance", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        Method method2 = clazz.getMethod("convert", Node.class, OutputStream.class, String.class, Class.forName("net.sourceforge.jeuclid.LayoutContext"));
        this.dim = (Dimension2D)method2.invoke(object, this.mathML, byteArrayOutputStream, "image/svg+xml", this.getLayout());
        return new String(byteArrayOutputStream.toByteArray());
    }

    public BufferedImage getImage() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        Class<?> clazz = Class.forName("net.sourceforge.jeuclid.converter.Converter");
        Method method = clazz.getMethod("getInstance", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        Method method2 = clazz.getMethod("render", Node.class, Class.forName("net.sourceforge.jeuclid.LayoutContext"));
        BufferedImage bufferedImage = (BufferedImage)method2.invoke(object, this.mathML, this.getLayout());
        this.dim = new Dimension2DDouble(bufferedImage.getWidth(), bufferedImage.getHeight());
        return bufferedImage;
    }

    private Object getLayout() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchFieldException, SecurityException {
        Class<?> clazz = Class.forName("net.sourceforge.jeuclid.context.LayoutContextImpl");
        Class<?> clazz2 = Class.forName("net.sourceforge.jeuclid.context.Parameter");
        Method method = clazz.getMethod("getDefaultLayoutContext", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        Method method2 = clazz.getMethod("setParameter", clazz2, Object.class);
        method2.invoke(object, clazz2.getDeclaredField("SCRIPTSIZEMULTIPLIER").get(null), Float.valueOf(2.0f));
        return object;
    }

    public Dimension2D getDimension() {
        return this.dim;
    }

    static {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AsciiMathOld.class.getResourceAsStream("/net/sourceforge/plantuml/math/AsciiMathParser.js"), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            bufferedReader.close();
            JAVASCRIPT_CODE = stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

