/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ugraphic.UFont;

public class UnusedSpace {
    private static final int HALF_SIZE = 20;
    private double meanX2;
    private double meanY2;
    private final List<Point> points = new ArrayList<Point>();
    private static final Map<Object, UnusedSpace> cache = new HashMap<Object, UnusedSpace>();

    public static UnusedSpace getUnusedSpace(UFont uFont, char c) {
        List<Object> list = Arrays.asList(uFont, Character.valueOf(c));
        UnusedSpace unusedSpace = cache.get(list);
        if (unusedSpace == null) {
            unusedSpace = new UnusedSpace(uFont, c);
            cache.put(list, unusedSpace);
        }
        return unusedSpace;
    }

    private UnusedSpace(UFont uFont, char c) {
        BufferedImage bufferedImage = new BufferedImage(40, 40, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(uFont.getFont());
        graphics2D.drawString("" + c, 20, 20);
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                if (!UnusedSpace.isPoint(bufferedImage, i, j)) continue;
                if (i < n) {
                    n = i;
                }
                if (j < n2) {
                    n2 = j;
                }
                if (i > n3) {
                    n3 = i;
                }
                if (j > n4) {
                    n4 = j;
                }
                this.points.add(new Point(i, j));
            }
        }
        double d = Double.MAX_VALUE;
        for (int i = n * 4; i <= n3 * 4; ++i) {
            for (int j = n2 * 4; j < n4 * 4; ++j) {
                Point point2 = new Point((double)i / 4.0, (double)j / 4.0);
                double d2 = this.biggestDistSqFromPoint(point2);
                if (!(d2 < d)) continue;
                d = d2;
                this.meanX2 = (double)i / 4.0 - 20.0;
                this.meanY2 = (double)j / 4.0 - 20.0;
            }
        }
    }

    private double biggestDistSqFromPoint(Point point2) {
        double d = 0.0;
        for (Point point3 : this.points) {
            double d2 = point2.getDistSq(point3);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private static boolean isPoint(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getRGB(n, n2) & 0xFFFFFF;
        return n3 != 0;
    }

    public double getCenterX() {
        return this.meanX2;
    }

    public double getCenterY() {
        return this.meanY2;
    }

    static class Point {
        private final double x;
        private final double y;

        Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getDistSq(Point point2) {
            double d = this.x - point2.x;
            double d2 = this.y - point2.y;
            return d * d + d2 * d2;
        }
    }
}

