/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolDatabase
extends USymbol {
    USymbolDatabase() {
    }

    public SkinParameter getSkinParameter() {
        return SkinParameter.DATABASE;
    }

    private void drawDatabase(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(0.0, 10.0);
        uPath.cubicTo(0.0, 0.0, d / 2.0, 0.0, d / 2.0, 0.0);
        uPath.cubicTo(d / 2.0, 0.0, d, 0.0, d, 10.0);
        uPath.lineTo(d, d2 - 10.0);
        uPath.cubicTo(d, d2, d / 2.0, d2, d / 2.0, d2);
        uPath.cubicTo(d / 2.0, d2, 0.0, d2, 0.0, d2 - 10.0);
        uPath.lineTo(0.0, 10.0);
        uGraphic.draw(uPath);
        UPath uPath2 = this.getClosingPath(d);
        uGraphic.apply(new UChangeBackColor(null)).draw(uPath2);
    }

    private UPath getClosingPath(double d) {
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 10.0);
        uPath.cubicTo(0.0, 20.0, d / 2.0, 20.0, d / 2.0, 20.0);
        uPath.cubicTo(d / 2.0, 20.0, d, 20.0, d, 10.0);
        return uPath;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 24.0, 5.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolDatabase.this.drawDatabase(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolDatabase.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                MyUGraphicDatabase myUGraphicDatabase = new MyUGraphicDatabase(uGraphic, dimension2D.getWidth());
                textBlock.drawU(myUGraphicDatabase.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolDatabase.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolDatabase.this.drawDatabase(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(d3, 0.0)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d22 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d22, 21.0)));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public boolean manageHorizontalLine() {
        return true;
    }

    public int suppHeightBecauseOfShape() {
        return 15;
    }

    class MyUGraphicDatabase
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        protected AbstractUGraphicHorizontalLine copy(UGraphic uGraphic) {
            return new MyUGraphicDatabase(uGraphic, this.endingX);
        }

        public MyUGraphicDatabase(UGraphic uGraphic, double d) {
            super(uGraphic);
            this.endingX = d;
        }

        protected void drawHline(UGraphic uGraphic, UHorizontalLine uHorizontalLine, UTranslate uTranslate) {
            UPath uPath = USymbolDatabase.this.getClosingPath(this.endingX);
            uGraphic = uGraphic.apply(uTranslate);
            uGraphic.apply(uHorizontalLine.getStroke()).apply(new UChangeBackColor(null)).apply(new UTranslate(0.0, -15.0)).draw(uPath);
            if (uHorizontalLine.isDouble()) {
                uGraphic.apply(uHorizontalLine.getStroke()).apply(new UChangeBackColor(null)).apply(new UTranslate(0.0, -13.0)).draw(uPath);
            }
            uHorizontalLine.drawTitleInternal(uGraphic, 0.0, this.endingX, 0.0, true);
        }
    }
}

