/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockSprited
extends TextBlockSimple {
    private final TextBlock sprite;

    public TextBlockSprited(TextBlock textBlock, Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        super(display, fontConfiguration, horizontalAlignment, spriteContainer, 0.0);
        this.sprite = textBlock;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getCircledCharacterWithAndMargin(stringBounder);
        double d2 = this.sprite.calculateDimension(stringBounder).getHeight();
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getCircledCharacterWithAndMargin(StringBounder stringBounder) {
        return this.sprite.calculateDimension(stringBounder).getWidth() + 6.0;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.sprite.drawU(uGraphic);
        double d = this.getCircledCharacterWithAndMargin(stringBounder);
        super.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
    }
}

