/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rainbow {
    private final List<HtmlColorAndStyle> colors = new ArrayList<HtmlColorAndStyle>();
    private final int colorArrowSeparationSpace;

    private Rainbow(int n) {
        this.colorArrowSeparationSpace = n;
    }

    public String toString() {
        return this.colors.toString();
    }

    public static Rainbow none() {
        return new Rainbow(0);
    }

    public Rainbow withDefault(Rainbow rainbow) {
        if (this.size() == 0) {
            return rainbow;
        }
        return this;
    }

    public static Rainbow build(HtmlColorAndStyle htmlColorAndStyle) {
        if (htmlColorAndStyle == null) {
            throw new IllegalArgumentException();
        }
        Rainbow rainbow = new Rainbow(0);
        rainbow.colors.add(htmlColorAndStyle);
        return rainbow;
    }

    public static Rainbow build(ISkinParam iSkinParam, String string, int n) {
        if (string == null) {
            return Rainbow.none();
        }
        Rainbow rainbow = new Rainbow(n);
        for (String string2 : string.split(";")) {
            rainbow.colors.add(HtmlColorAndStyle.build(iSkinParam, string2));
        }
        return rainbow;
    }

    public List<HtmlColorAndStyle> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public HtmlColor getColor() {
        return this.colors.get(0).getColor();
    }

    public int getColorArrowSeparationSpace() {
        return this.colorArrowSeparationSpace;
    }

    public int size() {
        return this.colors.size();
    }
}

