/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FontStyle {
    PLAIN,
    ITALIC,
    BOLD,
    UNDERLINE,
    STRIKE,
    WAVE,
    BACKCOLOR;


    public UFont mutateFont(UFont uFont) {
        if (this == PLAIN) {
            return uFont.withStyle(0);
        }
        if (this == ITALIC) {
            return uFont.withStyle(uFont.getStyle() | 2);
        }
        if (this == BOLD) {
            return uFont.withStyle(uFont.getStyle() | 1);
        }
        return uFont;
    }

    public String getActivationPattern() {
        if (this == PLAIN) {
            return "\\<[pP][lL][aA][iI][nN]\\>";
        }
        if (this == ITALIC) {
            return "\\<[iI]\\>";
        }
        if (this == BOLD) {
            return "\\<[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == WAVE) {
            return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        if (this == BACKCOLOR) {
            return "\\<[bB][aA][cC][kK](?::(#?\\w+(?:[-\\\\|/]#?\\w+)?))?\\>";
        }
        if (this == STRIKE) {
            return "\\<(?:s|S|strike|STRIKE|del|DEL)(?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
        }
        return null;
    }

    public boolean canHaveExtendedColor() {
        if (this == UNDERLINE) {
            return true;
        }
        if (this == WAVE) {
            return true;
        }
        if (this == BACKCOLOR) {
            return true;
        }
        return this == STRIKE;
    }

    public String getCreoleSyntax() {
        if (this == ITALIC) {
            return "//";
        }
        if (this == BOLD) {
            return "\\*\\*";
        }
        if (this == UNDERLINE) {
            return "__";
        }
        if (this == WAVE) {
            return "~~";
        }
        if (this == STRIKE) {
            return "--";
        }
        throw new UnsupportedOperationException();
    }

    public HtmlColor getExtendedColor(String string) {
        Matcher2 matcher2 = MyPattern.cmpile(this.getActivationPattern()).matcher(string);
        if (!matcher2.find() || matcher2.groupCount() != 1) {
            return null;
        }
        String string2 = matcher2.group(1);
        if (HtmlColorSet.getInstance().getColorIfValid(string2) != null) {
            return HtmlColorSet.getInstance().getColorIfValid(string2);
        }
        return null;
    }

    public String getDeactivationPattern() {
        if (this == PLAIN) {
            return "\\</[pP][lL][aA][iI][nN]\\>";
        }
        if (this == ITALIC) {
            return "\\</[iI]\\>";
        }
        if (this == BOLD) {
            return "\\</[bB]\\>";
        }
        if (this == UNDERLINE) {
            return "\\</[uU]\\>";
        }
        if (this == WAVE) {
            return "\\</[wW]\\>";
        }
        if (this == BACKCOLOR) {
            return "\\</[bB][aA][cC][kK]\\>";
        }
        if (this == STRIKE) {
            return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";
        }
        return null;
    }

    public static FontStyle getStyle(String string) {
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (!string.matches(fontStyle.getActivationPattern()) && !string.matches(fontStyle.getDeactivationPattern())) continue;
            return fontStyle;
        }
        throw new IllegalArgumentException(string);
    }
}

