/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;

class ColorChange
implements FontChange {
    private static final Pattern2 colorPattern = MyPattern.cmpile("(?i)\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>");
    private final HtmlColor color;

    ColorChange(String string) {
        Matcher2 matcher2 = colorPattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalArgumentException();
        }
        this.color = HtmlColorSet.getInstance().getColorIfValid(matcher2.group(1));
    }

    HtmlColor getColor() {
        return this.color;
    }

    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        return fontConfiguration.changeColor(this.color);
    }
}

