/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Locale;
import net.sourceforge.plantuml.geom.AbstractLineSegment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LineSegmentDouble
extends AbstractLineSegment {
    private final Point2D p1;
    private final Point2D p2;

    public String toString() {
        return String.format(Locale.US, "( %.2f,%.2f - %.2f,%.2f )", this.getP1().getX(), this.getP1().getY(), this.getP2().getX(), this.getP2().getY());
    }

    public LineSegmentDouble(double d, double d2, double d3, double d4) {
        this(new Point2D.Double(d, d2), new Point2D.Double(d3, d4));
    }

    public LineSegmentDouble(Point2D point2D, Point2D point2D2) {
        this.p1 = point2D;
        this.p2 = point2D2;
        if (point2D.equals(point2D2)) {
            throw new IllegalArgumentException();
        }
        assert (point2D != null && point2D2 != null);
        assert (this.getLength() > 0.0);
        assert (this.getDistance(this) == 0.0);
    }

    public LineSegmentDouble(CubicCurve2D.Double double_) {
        this(double_.getP1(), double_.getP2());
    }

    public LineSegmentDouble translate(UTranslate uTranslate) {
        return new LineSegmentDouble(uTranslate.getTranslated(this.getP1()), uTranslate.getTranslated(this.getP2()));
    }

    public Point2D getP1() {
        return this.p1;
    }

    public Point2D getP2() {
        return this.p2;
    }

    public double getX1() {
        return this.p1.getX();
    }

    public double getX2() {
        return this.p2.getX();
    }

    public double getY1() {
        return this.p1.getY();
    }

    public double getY2() {
        return this.p2.getY();
    }

    public void draw(UGraphic uGraphic) {
        double d = this.p1.getX();
        double d2 = this.p1.getY();
        double d3 = this.p2.getX();
        double d4 = this.p2.getY();
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        uGraphic.draw(new ULine(d3 - d, d4 - d2));
    }
}

