/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.geom.LineSegmentDouble;

public abstract class AbstractLineSegment
extends Line2D {
    public final boolean equals(Object object) {
        AbstractLineSegment abstractLineSegment = (AbstractLineSegment)object;
        return this.getP1().equals(abstractLineSegment.getP1()) && this.getP2().equals(abstractLineSegment.getP2());
    }

    public final int hashCode() {
        int n = 7;
        n = n * 17 + this.getP1().hashCode();
        n = n * 17 + this.getP2().hashCode();
        return n;
    }

    public final double getLength() {
        return Math.sqrt((this.getP2().getX() - this.getP1().getX()) * (this.getP2().getX() - this.getP1().getX()) + (this.getP2().getY() - this.getP1().getY()) * (this.getP2().getY() - this.getP1().getY()));
    }

    protected final Point2D.Double getPoint2D(double d) {
        double d2 = this.getP1().getX() + d * (this.getP2().getX() - this.getP1().getX());
        double d3 = this.getP1().getY() + d * (this.getP2().getY() - this.getP1().getY());
        return new Point2D.Double(d2, d3);
    }

    public final double getDistance(Point2D point2D) {
        return this.ptSegDist(point2D);
    }

    public Point2D getSegIntersection(AbstractLineSegment abstractLineSegment) {
        double d;
        if (abstractLineSegment.isVertical()) {
            d = this.getIntersectionVertical(abstractLineSegment.getP1().getX());
        } else if (abstractLineSegment.isHorizontal()) {
            d = this.getIntersectionHorizontal(abstractLineSegment.getP1().getY());
        } else {
            return this.getDichoIntersection(abstractLineSegment);
        }
        if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            return null;
        }
        Point2D.Double double_ = this.getPoint2D(d);
        if (AbstractLineSegment.isBetween(double_, abstractLineSegment.getP1(), abstractLineSegment.getP2())) {
            return double_;
        }
        return null;
    }

    private Point2D getDichoIntersection(AbstractLineSegment abstractLineSegment) {
        if (!this.doesIntersect(abstractLineSegment)) {
            return null;
        }
        if (abstractLineSegment.getLength() < 0.01) {
            return abstractLineSegment.getMiddle();
        }
        LineSegmentDouble lineSegmentDouble = new LineSegmentDouble(abstractLineSegment.getP1(), abstractLineSegment.getMiddle());
        LineSegmentDouble lineSegmentDouble2 = new LineSegmentDouble(abstractLineSegment.getMiddle(), abstractLineSegment.getP2());
        if (this.doesIntersect(lineSegmentDouble)) {
            return this.getDichoIntersection(lineSegmentDouble);
        }
        if (this.doesIntersect(lineSegmentDouble2)) {
            return this.getDichoIntersection(lineSegmentDouble2);
        }
        throw new IllegalStateException();
    }

    private Point2D.Double getMiddle() {
        return this.getPoint2D(0.5);
    }

    private static boolean isBetween(double d, double d2, double d3) {
        if (d2 < d3) {
            return d >= d2 && d <= d3;
        }
        assert (d3 <= d2);
        return d >= d3 && d <= d2;
    }

    static boolean isBetween(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return AbstractLineSegment.isBetween(point2D.getX(), point2D2.getX(), point2D3.getX()) && AbstractLineSegment.isBetween(point2D.getY(), point2D2.getY(), point2D3.getY());
    }

    public double getIntersectionVertical(double d) {
        double d2 = this.getP2().getX() - this.getP1().getX();
        if (d2 == 0.0) {
            return Double.NaN;
        }
        return (d - this.getP1().getX()) / d2;
    }

    public double getIntersectionHorizontal(double d) {
        double d2 = this.getP2().getY() - this.getP1().getY();
        if (d2 == 0.0) {
            return Double.NaN;
        }
        return (d - this.getP1().getY()) / d2;
    }

    public final void setLine(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException();
    }

    public final Rectangle2D getBounds2D() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.getX1() < this.getX2()) {
            d4 = this.getX1();
            d3 = this.getX2() - this.getX1();
        } else {
            d4 = this.getX2();
            d3 = this.getX1() - this.getX2();
        }
        if (this.getY1() < this.getY2()) {
            d2 = this.getY1();
            d = this.getY2() - this.getY1();
        } else {
            d2 = this.getY2();
            d = this.getY1() - this.getY2();
        }
        return new Rectangle2D.Double(d4, d2, d3, d);
    }

    public final boolean isHorizontal() {
        return this.getP1().getY() == this.getP2().getY();
    }

    public final boolean isVertical() {
        return this.getP1().getX() == this.getP2().getX();
    }

    public final double getDistance(AbstractLineSegment abstractLineSegment) {
        double d = this.getDistanceInternal(abstractLineSegment);
        assert (this.equals(d, abstractLineSegment.getDistanceInternal(this)));
        return d;
    }

    private boolean equals(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-4;
    }

    public boolean isPointOnSegment(Point2D point2D) {
        return this.equals(point2D.distance(this.getP1()) + point2D.distance(this.getP2()), this.getLength());
    }

    private double getDistanceInternal(AbstractLineSegment abstractLineSegment) {
        double d = this.getDistance(abstractLineSegment.getP1());
        d += this.getDistance(abstractLineSegment.getP2());
        d += abstractLineSegment.getDistance(this.getP1());
        return d += abstractLineSegment.getDistance(this.getP2());
    }

    public final double getAngle() {
        return Math.atan2(this.getP2().getY() - this.getP1().getY(), this.getP2().getX() - this.getP1().getX());
    }

    public final double getOppositeAngle() {
        return Math.atan2(this.getP1().getY() - this.getP2().getY(), this.getP1().getX() - this.getP2().getX());
    }

    public final Point2D.Double startTranslatedAsVector(double d) {
        double d2 = 1.0 * d / 100.0;
        double d3 = this.getP1().getX() + d2 * (this.getP2().getX() - this.getP1().getX());
        double d4 = this.getP1().getY() + d2 * (this.getP2().getY() - this.getP1().getY());
        return new Point2D.Double(d3, d4);
    }

    public boolean doesIntersect(AbstractLineSegment abstractLineSegment) {
        boolean bl = this.doesIntersectInternal(abstractLineSegment);
        assert (bl == abstractLineSegment.doesIntersectInternal(this));
        return bl;
    }

    private boolean doesIntersectInternal(AbstractLineSegment abstractLineSegment) {
        boolean bl;
        double d = AbstractLineSegment.direction(abstractLineSegment.getP1(), abstractLineSegment.getP2(), this.getP1());
        double d2 = AbstractLineSegment.direction(abstractLineSegment.getP1(), abstractLineSegment.getP2(), this.getP2());
        double d3 = AbstractLineSegment.direction(this.getP1(), this.getP2(), abstractLineSegment.getP1());
        double d4 = AbstractLineSegment.direction(this.getP1(), this.getP2(), abstractLineSegment.getP2());
        if (d == 0.0 && AbstractLineSegment.isBetween(this.getP1(), abstractLineSegment.getP1(), abstractLineSegment.getP2())) {
            return true;
        }
        if (d2 == 0.0 && AbstractLineSegment.isBetween(this.getP2(), abstractLineSegment.getP1(), abstractLineSegment.getP2())) {
            return true;
        }
        if (d3 == 0.0 && AbstractLineSegment.isBetween(abstractLineSegment.getP1(), this.getP1(), this.getP2())) {
            return true;
        }
        if (d4 == 0.0 && AbstractLineSegment.isBetween(abstractLineSegment.getP2(), this.getP1(), this.getP2())) {
            return true;
        }
        boolean bl2 = bl = AbstractLineSegment.signDiffers(d, d2) && AbstractLineSegment.signDiffers(d3, d4);
        assert (this.intersectsLine(abstractLineSegment) == bl);
        return bl;
    }

    private static double direction(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return AbstractLineSegment.determinant(point2D3.getX() - point2D.getX(), point2D3.getY() - point2D.getY(), point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    private static boolean signDiffers(double d, double d2) {
        if (d > 0.0 && d2 < 0.0) {
            return true;
        }
        return d < 0.0 && d2 > 0.0;
    }

    public double determinant(AbstractLineSegment abstractLineSegment) {
        return AbstractLineSegment.determinant(this.getP1().getX() - this.getP2().getX(), this.getP1().getY() - this.getP2().getY(), abstractLineSegment.getP1().getX() - abstractLineSegment.getP2().getX(), abstractLineSegment.getP1().getY() - abstractLineSegment.getP2().getY());
    }

    private static double determinant(double d, double d2, double d3, double d4) {
        return d * d4 - d3 * d2;
    }

    public double side(Point2D point2D) {
        return AbstractLineSegment.direction(this.getP1(), this.getP2(), point2D);
    }
}

