/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.fun;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class IconLoader {
    private static final int NUMBER_OF_ICONS = 21;
    private static final Map<String, BufferedImage> all = new ConcurrentHashMap<String, BufferedImage>();

    public static BufferedImage getRandom() {
        return IconLoader.addTransparent(IconLoader.getIcon(IconLoader.getSomeQuote()));
    }

    private static String getSomeQuote() {
        int n = (int)(System.currentTimeMillis() / 1000L);
        int n2 = n % 21;
        return "sprite" + String.format("%03d", n2) + ".png";
    }

    private static BufferedImage getIcon(String string) {
        BufferedImage bufferedImage = all.get(string);
        if (bufferedImage == null && (bufferedImage = IconLoader.getIconSlow(string)) != null) {
            all.put(string, bufferedImage);
        }
        return bufferedImage;
    }

    private static BufferedImage getIconSlow(String string) {
        try {
            InputStream inputStream = IconLoader.class.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            return bufferedImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static BufferedImage addTransparent(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getRGB(i, j);
                if (n == bufferedImage.getRGB(0, 0)) continue;
                bufferedImage2.setRGB(i, j, n);
            }
        }
        return bufferedImage2;
    }
}

