/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArchimate
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandArchimate() {
        super(CommandArchimate.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "archimate"), new RegexLeaf("[%s]+"), CommandArchimate.color().getRegex(), new RegexLeaf("[%s]+"), new RegexOr(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g][^%g]+[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])"), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(?:\\<\\<([-\\w]+)\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("CODE3", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])"), new RegexLeaf("STEREOTYPE3", "(?:[%s]+(?:\\<\\<([-\\w]+)\\>\\>))?"), new RegexLeaf("[%s]+as[%s]*"), new RegexLeaf("DISPLAY3", "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("DISPLAY4", "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)"), new RegexLeaf("STEREOTYPE4", "(?:[%s]+(?:\\<\\<([-\\w]+)\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE4", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])"))), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(?:[%s]*(?:\\<\\<([-\\w]+)\\>\\>))?"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        String string = regexResult.getLazzy("CODE", 0);
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
        String string2 = regexResult.getLazzy("STEREOTYPE", 0);
        ILeaf iLeaf = descriptionDiagram.getOrCreateLeaf(code, LeafType.DESCRIPTION, USymbol.RECTANGLE);
        String string3 = regexResult.getLazzy("DISPLAY", 0);
        String string4 = string3;
        if (string4 == null) {
            string4 = code.getFullName();
        }
        string4 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string4);
        iLeaf.setDisplay(Display.getWithNewlines(string4));
        iLeaf.setUSymbol(USymbol.RECTANGLE);
        if (string2 != null) {
            iLeaf.setStereotype(new Stereotype("<<$archimate/" + string2 + ">>", descriptionDiagram.getSkinParam().getCircledCharacterRadius(), descriptionDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), descriptionDiagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimate.color().getColor(regexResult, descriptionDiagram.getSkinParam().getIHtmlColorSet());
        iLeaf.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

