/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class RotationZoom {
    private final double angle;
    private final double zoom;

    private RotationZoom(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.angle = d;
        this.zoom = d2;
    }

    public RotationZoom compose(RotationZoom rotationZoom) {
        return new RotationZoom(this.angle + rotationZoom.angle, this.zoom * rotationZoom.zoom);
    }

    public String toString() {
        return "Rotation=" + Math.toDegrees(this.angle) + " Zoom=" + this.zoom;
    }

    public static RotationZoom fromVarArgs(VarArgs varArgs) {
        double d = Math.toRadians(varArgs.getAsDouble("rotation", 0.0));
        double d2 = varArgs.getAsDouble("scale", 1.0);
        return new RotationZoom(d, d2);
    }

    public static RotationZoom rotationInDegrees(double d) {
        return new RotationZoom(Math.toRadians(d), 1.0);
    }

    public static RotationZoom rotationInRadians(double d) {
        return new RotationZoom(d, 1.0);
    }

    public static RotationZoom zoom(double d) {
        return new RotationZoom(0.0, d);
    }

    public RotationZoom inverse() {
        return new RotationZoom(-this.angle, 1.0 / this.zoom);
    }

    public double getAngleDegree() {
        return Math.toDegrees(this.angle);
    }

    public static RotationZoom builtRotationOnYaxis(Point2D point2D) {
        double d = Math.atan2(point2D.getX(), point2D.getY());
        return new RotationZoom(d, 1.0);
    }

    public Point2D.Double getPoint(double d, double d2) {
        if (this.angle == 0.0) {
            return new Point2D.Double(d * this.zoom, d2 * this.zoom);
        }
        double d3 = Math.cos(this.angle) * d - Math.sin(this.angle) * d2;
        double d4 = Math.sin(this.angle) * d + Math.cos(this.angle) * d2;
        return new Point2D.Double(d3 * this.zoom, d4 * this.zoom);
    }

    public Point2D getPoint(Point2D point2D) {
        return this.getPoint(point2D.getX(), point2D.getY());
    }

    public UTranslate getUTranslate(UTranslate uTranslate) {
        return new UTranslate(this.getPoint(uTranslate.getDx(), uTranslate.getDy()));
    }

    public static RotationZoom none() {
        return new RotationZoom(0.0, 1.0);
    }

    public boolean isNone() {
        return this.angle == 0.0 && this.zoom == 1.0;
    }

    public double applyZoom(double d) {
        return d * this.zoom;
    }

    public double applyRotation(double d) {
        return this.angle + d;
    }
}

