/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.ApolloniusSolver2;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.cute.Tension;
import net.sourceforge.plantuml.cute.TriangleCorner;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class BetweenCorners {
    private final TriangleCorner corner1;
    private final TriangleCorner corner2;
    private final Tension tension;
    private Balloon inside1;
    private Balloon inside2;
    private Balloon contact;
    private Balloon apo;
    private Point2D apopt1;
    private Point2D apopt2;

    public BetweenCorners(TriangleCorner triangleCorner, TriangleCorner triangleCorner2, Tension tension) {
        this.corner1 = triangleCorner;
        this.corner2 = triangleCorner2;
        this.tension = tension;
        if (triangleCorner.hasCurvation()) {
            this.inside1 = triangleCorner.getBalloonInside();
        }
        if (triangleCorner2.hasCurvation()) {
            this.inside2 = triangleCorner2.getBalloonInside();
        }
        if (!tension.isNone()) {
            this.contact = new Balloon(this.getTensionPoint(), this.getLength() / 1000.0);
        }
        if (this.inside1 != null && this.inside2 != null && this.contact != null) {
            this.apo = ApolloniusSolver2.solveApollonius(this.inside1, this.inside2, this.contact, 1, 1, 1);
            this.apopt1 = this.apo.getPointOnCirclePassingByThisPoint(this.inside1.getCenter());
            this.apopt2 = this.apo.getPointOnCirclePassingByThisPoint(this.inside2.getCenter());
        }
    }

    public Point2D getPointJ() {
        if (!this.getCorner1().hasCurvation()) {
            return this.getCorner1().getO();
        }
        if (this.tension.isNone()) {
            return this.getCorner1().getOnSegmentA(this.getCorner1().getCurvation());
        }
        throw new UnsupportedOperationException();
    }

    public Point2D getPointK() {
        if (!this.getCorner1().hasCurvation()) {
            return this.getCorner1().getO();
        }
        if (this.tension.isNone()) {
            return this.getCorner1().getOnSegmentB(this.getCorner1().getCurvation());
        }
        throw new UnsupportedOperationException();
    }

    private double getBalloonRadius() {
        return this.getCorner1().getBalloonInside().getRadius();
    }

    public void initPath(UPath uPath) {
        if (this.apo != null) {
            uPath.moveTo(this.apopt2);
        } else {
            uPath.moveTo(this.getPointK());
        }
    }

    public void addToPath(UPath uPath, int n) {
        if (this.apo != null) {
            uPath.arcTo(this.apopt1, this.getCorner1().getBalloonInside().getRadius(), 0.0, 1.0);
            uPath.arcTo(this.apopt2, this.apo.getRadius(), 0.0, 1.0);
        } else {
            uPath.lineTo(this.getPointJ());
            if (this.getCorner1().hasCurvation()) {
                uPath.arcTo(this.getPointK(), this.getBalloonRadius(), 0.0, n);
            }
        }
    }

    public void debugMe(UGraphic uGraphic) {
        if (!this.getCorner2().hasCurvation()) {
            return;
        }
        if (this.tension.isNone()) {
            return;
        }
        this.inside1.drawU(uGraphic);
        this.inside2.drawU(uGraphic);
        this.contact.drawU(uGraphic);
        new Balloon(this.apopt1, 5.0).drawU(uGraphic);
        new Balloon(this.apopt2, 5.0).drawU(uGraphic);
        this.apo.drawU(uGraphic);
    }

    private double getRadiusFuzzy1() {
        double d = this.getLength() / 2.0;
        double d2 = this.getTension().getValue();
        double d3 = (d * d + d2 * d2) / 2.0 / d2;
        return d3;
    }

    private Segment getSegment() {
        return new Segment(this.getCorner1().getO(), this.getCorner2().getO());
    }

    private Point2D getTensionPoint() {
        return this.getSegment().getOrthoPoint(this.getTension().getValue());
    }

    private Segment getSegmentCross() {
        return new Segment(this.getCorner1().getCornerOrBalloonCenter(), this.getCorner2().getCornerOrBalloonCenter());
    }

    public Tension getTension() {
        return this.tension;
    }

    public TriangleCorner getCorner1() {
        return this.corner1;
    }

    public TriangleCorner getCorner2() {
        return this.corner2;
    }

    public double getLength() {
        return this.getSegment().getLength();
    }
}

