/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;
import net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLinux;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizWindows;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.VizJsEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizUtils {
    private static final String VIZJS = "vizjs";
    private static int DOT_VERSION_LIMIT = 226;
    private static String dotExecutable;
    private static String dotVersion;

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static final String getDotExecutableForTest() {
        return dotExecutable;
    }

    public static final void setDotExecutable(String string) {
        dotExecutable = string;
    }

    public static Graphviz create(ISkinParam iSkinParam, String string, String ... stringArray) {
        if (GraphvizUtils.useVizJs(iSkinParam)) {
            Log.info("Using vizjs");
            return new GraphvizJs(string);
        }
        AbstractGraphviz abstractGraphviz = GraphvizUtils.isWindows() ? new GraphvizWindows(iSkinParam, string, stringArray) : new GraphvizLinux(iSkinParam, string, stringArray);
        if (abstractGraphviz.getExeState() != ExeState.OK && VizJsEngine.isOk()) {
            Log.info("Error with file " + abstractGraphviz.getDotExe() + ": " + abstractGraphviz.getExeState().getTextMessage());
            Log.info("Using vizjs");
            return new GraphvizJs(string);
        }
        return abstractGraphviz;
    }

    private static boolean useVizJs(ISkinParam iSkinParam) {
        if (iSkinParam != null && VIZJS.equalsIgnoreCase(iSkinParam.getDotExecutable()) && VizJsEngine.isOk()) {
            return true;
        }
        return VIZJS.equalsIgnoreCase(GraphvizUtils.getenvGraphvizDot()) && VizJsEngine.isOk();
    }

    public static File getDotExe() {
        return GraphvizUtils.create(null, "png", new String[0]).getDotExe();
    }

    public static String getenvGraphvizDot() {
        if (StringUtils.isNotEmpty(dotExecutable)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(dotExecutable);
        }
        String string = System.getProperty("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(string)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        String string2 = System.getenv("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(string2)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        return null;
    }

    public static int getenvImageLimit() {
        String string = System.getProperty("PLANTUML_LIMIT_SIZE");
        if (StringUtils.isNotEmpty(string) && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        String string2 = System.getenv("PLANTUML_LIMIT_SIZE");
        if (StringUtils.isNotEmpty(string2) && string2.matches("\\d+")) {
            return Integer.parseInt(string2);
        }
        return 4096;
    }

    public static String getenvLogData() {
        String string = System.getProperty("PLANTUML_LOGDATA");
        if (StringUtils.isNotEmpty(string)) {
            return string;
        }
        return System.getenv("PLANTUML_LOGDATA");
    }

    public static String dotVersion() throws IOException, InterruptedException {
        if (dotVersion == null) {
            File file = GraphvizUtils.getDotExe();
            ExeState exeState = ExeState.checkFile(file);
            dotVersion = exeState == ExeState.OK ? GraphvizUtils.create(null, "png", new String[0]).dotVersion() : "Error:" + exeState.getTextMessage(file);
        }
        return dotVersion;
    }

    public static int retrieveVersion(String string) {
        if (string == null) {
            return -1;
        }
        Pattern pattern = Pattern.compile("\\s([12].\\d\\d)\\D");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return -1;
        }
        return Integer.parseInt(matcher.group(1).replaceAll("\\.", ""));
    }

    public static int getDotVersion() throws IOException, InterruptedException {
        return GraphvizUtils.retrieveVersion(GraphvizUtils.dotVersion());
    }

    public static List<String> getTestDotStrings(boolean bl) {
        ArrayList<String> arrayList;
        block15: {
            String string = "";
            String string2 = "";
            if (bl) {
                string = "<b><color:red>";
                string2 = "<b>";
            }
            arrayList = new ArrayList<String>();
            if (GraphvizUtils.useVizJs(null)) {
                arrayList.add("VizJs library is used!");
                try {
                    String string3 = GraphvizUtils.getTestCreateSimpleFile();
                    if (string3 == null) {
                        arrayList.add(string2 + "Installation seems OK. File generation OK");
                    } else {
                        arrayList.add(string + string3);
                    }
                }
                catch (Exception exception) {
                    arrayList.add(string + exception.toString());
                    exception.printStackTrace();
                }
                return Collections.unmodifiableList(arrayList);
            }
            String string4 = GraphvizUtils.getenvGraphvizDot();
            if (string4 == null) {
                arrayList.add("The environment variable GRAPHVIZ_DOT has not been set");
            } else {
                arrayList.add("The environment variable GRAPHVIZ_DOT has been set to " + string4);
            }
            File file = GraphvizUtils.getDotExe();
            arrayList.add("Dot executable is " + file);
            ExeState exeState = ExeState.checkFile(file);
            if (exeState == ExeState.OK) {
                try {
                    String string5 = GraphvizUtils.dotVersion();
                    arrayList.add("Dot version: " + string5);
                    int n = GraphvizUtils.getDotVersion();
                    if (n == -1) {
                        arrayList.add("Warning : cannot determine dot version");
                        break block15;
                    }
                    if (n < DOT_VERSION_LIMIT) {
                        arrayList.add(string2 + "Warning : Your dot installation seems old");
                        arrayList.add(string2 + "Some diagrams may have issues");
                        break block15;
                    }
                    String string6 = GraphvizUtils.getTestCreateSimpleFile();
                    if (string6 == null) {
                        arrayList.add(string2 + "Installation seems OK. File generation OK");
                        break block15;
                    }
                    arrayList.add(string + string6);
                }
                catch (Exception exception) {
                    arrayList.add(string + exception.toString());
                    exception.printStackTrace();
                }
            } else {
                arrayList.add(string + "Error: " + exeState.getTextMessage());
                arrayList.add("Error: only sequence diagrams will be generated");
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String getTestCreateSimpleFile() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        Graphviz graphviz = GraphvizUtils.create(null, "digraph foo { test; }", "svg");
        ProcessState processState = graphviz.createFile3(byteArrayOutputStream = new ByteArrayOutputStream());
        if (processState.differs(ProcessState.TERMINATED_OK())) {
            return "Error: timeout " + processState;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length == 0) {
            return "Error: dot generates empty file. Check you dot installation.";
        }
        String string = new String(byArray);
        if (string.indexOf("<svg") == -1) {
            return "Error: dot generates unreadable SVG file. Check you dot installation.";
        }
        return null;
    }

    static {
        dotVersion = null;
    }
}

