/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.EnumSet;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityPosition {
    NORMAL,
    ENTRY_POINT,
    EXIT_POINT,
    INPUT_PIN,
    OUTPUT_PIN,
    EXPANSION_INPUT,
    EXPANSION_OUTPUT;

    public static final double RADIUS = 6.0;

    public void drawSymbol(UGraphic uGraphic, Rankdir rankdir) {
        if (this == NORMAL) {
            throw new IllegalStateException();
        }
        if (this == ENTRY_POINT || this == EXIT_POINT) {
            UEllipse uEllipse = new UEllipse(12.0, 12.0);
            uGraphic.draw(uEllipse);
            if (this == EXIT_POINT) {
                EntityPosition.drawLine(uGraphic, this.getPointOnCircle(6.5, 6.5, 0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 3.9269908169872414, 5.5));
                EntityPosition.drawLine(uGraphic, this.getPointOnCircle(6.5, 6.5, -0.7853981633974483, 5.5), this.getPointOnCircle(6.5, 6.5, 2.356194490192345, 5.5));
            }
        } else if (this == INPUT_PIN || this == OUTPUT_PIN) {
            URectangle uRectangle = new URectangle(12.0, 12.0);
            uGraphic.draw(uRectangle);
        } else if (this == EXPANSION_INPUT || this == EXPANSION_OUTPUT) {
            if (rankdir == Rankdir.TOP_TO_BOTTOM) {
                URectangle uRectangle = new URectangle(48.0, 12.0);
                uGraphic.draw(uRectangle);
                ULine uLine = new ULine(0.0, 12.0);
                uGraphic.apply(new UTranslate(12.0, 0.0)).draw(uLine);
                uGraphic.apply(new UTranslate(24.0, 0.0)).draw(uLine);
                uGraphic.apply(new UTranslate(36.0, 0.0)).draw(uLine);
            } else {
                URectangle uRectangle = new URectangle(12.0, 48.0);
                uGraphic.apply(new UTranslate(0.0, 0.0)).draw(uRectangle);
                ULine uLine = new ULine(12.0, 0.0);
                uGraphic.apply(new UTranslate(0.0, 12.0)).draw(uLine);
                uGraphic.apply(new UTranslate(0.0, 24.0)).draw(uLine);
                uGraphic.apply(new UTranslate(0.0, 36.0)).draw(uLine);
            }
        }
    }

    public Dimension2D getDimension(Rankdir rankdir) {
        if (this == EXPANSION_INPUT || this == EXPANSION_OUTPUT) {
            if (rankdir == Rankdir.TOP_TO_BOTTOM) {
                return new Dimension2DDouble(48.0, 12.0);
            }
            return new Dimension2DDouble(12.0, 48.0);
        }
        return new Dimension2DDouble(12.0, 12.0);
    }

    private Point2D getPointOnCircle(double d, double d2, double d3, double d4) {
        double d5 = d + d4 * Math.cos(d3);
        double d6 = d2 + d4 * Math.sin(d3);
        return new Point2D.Double(d5, d6);
    }

    private static void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        uGraphic.apply(new UTranslate(point2D.getX(), point2D.getY())).draw(new ULine(d, d2));
    }

    public ShapeType getShapeType() {
        if (this == NORMAL) {
            throw new IllegalStateException();
        }
        if (this == ENTRY_POINT || this == EXIT_POINT) {
            return ShapeType.CIRCLE;
        }
        return ShapeType.RECTANGLE;
    }

    public static EntityPosition fromStereotype(String string) {
        if ("<<entrypoint>>".equalsIgnoreCase(string)) {
            return ENTRY_POINT;
        }
        if ("<<exitpoint>>".equalsIgnoreCase(string)) {
            return EXIT_POINT;
        }
        if ("<<inputpin>>".equalsIgnoreCase(string)) {
            return INPUT_PIN;
        }
        if ("<<outputpin>>".equalsIgnoreCase(string)) {
            return OUTPUT_PIN;
        }
        if ("<<expansioninput>>".equalsIgnoreCase(string)) {
            return EXPANSION_INPUT;
        }
        if ("<<expansionoutput>>".equalsIgnoreCase(string)) {
            return EXPANSION_OUTPUT;
        }
        return NORMAL;
    }

    public static EnumSet<EntityPosition> getInputs() {
        return EnumSet.of(ENTRY_POINT, INPUT_PIN, EXPANSION_INPUT);
    }

    public static EnumSet<EntityPosition> getOutputs() {
        return EnumSet.of(EXIT_POINT, OUTPUT_PIN, EXPANSION_OUTPUT);
    }
}

