/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class EntityGenderUtils {
    public static EntityGender byEntityType(final LeafType leafType) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getLeafType() == leafType;
            }
        };
    }

    public static EntityGender byEntityAlone(final IEntity iEntity) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity2) {
                return iEntity2.getUid().equals(iEntity.getUid());
            }
        };
    }

    public static EntityGender byStereotype(final String string) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                if (iEntity.getStereotype() == null) {
                    return false;
                }
                return string.equals(iEntity.getStereotype().getLabel(false));
            }
        };
    }

    public static EntityGender byPackage(final IGroup iGroup) {
        if (EntityUtils.groupRoot(iGroup)) {
            throw new IllegalArgumentException();
        }
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                if (EntityUtils.groupRoot(iEntity.getParentContainer())) {
                    return false;
                }
                return iGroup == iEntity.getParentContainer();
            }
        };
    }

    public static EntityGender and(final EntityGender entityGender, final EntityGender entityGender2) {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return entityGender.contains(iEntity) && entityGender2.contains(iEntity);
            }
        };
    }

    public static EntityGender all() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return true;
            }
        };
    }

    public static EntityGender emptyMethods() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getBodier().getMethodsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyFields() {
        return new EntityGender(){

            public boolean contains(IEntity iEntity) {
                return iEntity.getBodier().getFieldsToDisplay().size() == 0;
            }
        };
    }
}

