/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.Fission;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.Sea;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SheetBlock1
extends AbstractTextBlock
implements TextBlock,
Atom,
Stencil {
    private final Sheet sheet;
    private List<Stripe> stripes;
    private Map<Stripe, Double> heights;
    private Map<Stripe, Double> widths;
    private Map<Atom, Position> positions;
    private MinMax minMax;
    private final LineBreakStrategy maxWidth;
    private final double padding;

    public SheetBlock1(Sheet sheet, LineBreakStrategy lineBreakStrategy, double d) {
        this.sheet = sheet;
        this.maxWidth = lineBreakStrategy;
        this.padding = d;
        if (lineBreakStrategy == null) {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        return this.sheet.toString();
    }

    public HorizontalAlignment getCellAlignment() {
        if (this.stripes.size() != 1) {
            return HorizontalAlignment.LEFT;
        }
        Stripe stripe = this.stripes.get(0);
        if (stripe instanceof StripeSimple) {
            return ((StripeSimple)stripe).getCellAlignment();
        }
        return HorizontalAlignment.LEFT;
    }

    private void initMap(StringBounder stringBounder) {
        double d;
        if (this.positions != null) {
            return;
        }
        this.stripes = new ArrayList<Stripe>();
        for (Stripe stripe : this.sheet) {
            this.stripes.addAll(new Fission(stripe, this.maxWidth).getSplitted(stringBounder));
        }
        this.positions = new LinkedHashMap<Atom, Position>();
        this.widths = new LinkedHashMap<Stripe, Double>();
        this.heights = new LinkedHashMap<Stripe, Double>();
        this.minMax = MinMax.getEmpty(true);
        double d2 = 0.0;
        for (Stripe stripe : this.stripes) {
            if (stripe.getAtoms().size() == 0) continue;
            Sea sea = new Sea(stringBounder);
            for (Atom object : stripe.getAtoms()) {
                sea.add(object);
            }
            sea.doAlign();
            sea.translateMinYto(d2);
            sea.exportAllPositions(this.positions);
            double d3 = sea.getWidth();
            this.widths.put(stripe, d3);
            this.minMax = sea.update(this.minMax);
            d = sea.getHeight();
            this.heights.put(stripe, d);
            d2 += d;
        }
        int n = this.sheet.getHorizontalAlignment() == HorizontalAlignment.CENTER ? 2 : (this.sheet.getHorizontalAlignment() == HorizontalAlignment.RIGHT ? 1 : 0);
        if (n != 0) {
            double d4 = 0.0;
            for (Double d3 : this.widths.values()) {
                if (!(d3 > d4)) continue;
                d4 = d3;
            }
            for (Map.Entry entry : this.widths.entrySet()) {
                d = d4 - (Double)entry.getValue();
                if (!(d > 0.0)) continue;
                for (Atom atom : ((Stripe)entry.getKey()).getAtoms()) {
                    Position position = this.positions.get(atom);
                    this.positions.put(atom, position.translateX(d / (double)n));
                }
            }
        }
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        return Dimension2DDouble.delta(this.minMax.getDimension(), 2.0 * this.padding);
    }

    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
        return null;
    }

    public void drawU(UGraphic uGraphic) {
        this.initMap(uGraphic.getStringBounder());
        if (this.padding > 0.0) {
            uGraphic = uGraphic.apply(new UTranslate(this.padding, this.padding));
        }
        for (Stripe stripe : this.stripes) {
            for (Atom atom : stripe.getAtoms()) {
                Position position = this.positions.get(atom);
                atom.drawU(position.translate(uGraphic));
            }
        }
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

