/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class CommandCreoleStyle
implements Command {
    private final Pattern2 p;
    private final FontStyle style;
    private final boolean tryExtendedColor;

    public static CommandCreoleStyle createCreole(FontStyle fontStyle) {
        return new CommandCreoleStyle("^(" + fontStyle.getCreoleSyntax() + "(.+?)" + fontStyle.getCreoleSyntax() + ")", fontStyle, false);
    }

    public static Command createLegacy(FontStyle fontStyle) {
        return new CommandCreoleStyle("^((" + fontStyle.getActivationPattern() + ")(.+?)" + fontStyle.getDeactivationPattern() + ")", fontStyle, fontStyle.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle fontStyle) {
        return new CommandCreoleStyle("^((" + fontStyle.getActivationPattern() + ")(.+))$", fontStyle, fontStyle.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String string, FontStyle fontStyle, boolean bl) {
        this.p = MyPattern.cmpile(string);
        this.style = fontStyle;
        this.tryExtendedColor = bl;
    }

    private HtmlColor getExtendedColor(Matcher2 matcher2) {
        if (this.tryExtendedColor) {
            return this.style.getExtendedColor(matcher2.group(2));
        }
        return null;
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.p.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = new AddStyle(this.style, this.getExtendedColor(matcher2)).apply(fontConfiguration);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        int n = matcher2.groupCount();
        stripeSimple.analyzeAndAdd(matcher2.group(n));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.p.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }
}

