/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Skeleton2;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomTree
implements Atom {
    private final HtmlColor lineColor;
    private final List<Atom> cells = new ArrayList<Atom>();
    private final Map<Atom, Integer> levels = new HashMap<Atom, Integer>();
    private final double margin = 2.0;

    public AtomTree(HtmlColor htmlColor) {
        this.lineColor = htmlColor;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Skeleton2 skeleton2 = new Skeleton2();
        double d = 0.0;
        double d2 = 0.0;
        for (Atom atom : this.cells) {
            Dimension2D dimension2D = atom.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            int n = this.getLevel(atom);
            d = Math.max(d, skeleton2.getXEndForLevel(n) + 2.0 + dimension2D.getWidth());
        }
        return new Dimension2DDouble(d, d2);
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public void drawU(UGraphic uGraphic) {
        Skeleton2 skeleton2 = new Skeleton2();
        double d = 0.0;
        UGraphic uGraphic2 = uGraphic;
        for (Atom atom : this.cells) {
            int n = this.getLevel(atom);
            atom.drawU(uGraphic2.apply(new UTranslate(2.0 + skeleton2.getXEndForLevel(n), 0.0)));
            Dimension2D dimension2D = atom.calculateDimension(uGraphic2.getStringBounder());
            skeleton2.add(n, d + dimension2D.getHeight() / 2.0);
            uGraphic2 = uGraphic2.apply(new UTranslate(0.0, dimension2D.getHeight()));
            d += dimension2D.getHeight();
        }
        skeleton2.draw(uGraphic.apply(new UChangeColor(this.lineColor)));
    }

    private int getLevel(Atom atom) {
        return this.levels.get(atom);
    }

    public void addCell(Atom atom, int n) {
        this.cells.add(atom);
        this.levels.put(atom, n);
    }
}

