/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.LeafType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaFile {
    private static final Pattern2 classDefinition = MyPattern.cmpile("^(?:public[%s]+|abstract[%s]+|final[%s]+)*(class|interface|enum|annotation)[%s]+(\\w+)(?:.*\\b(extends|implements)[%s]+([\\w%s,]+))?");
    private static final Pattern2 packageDefinition = MyPattern.cmpile("^package[%s]+([\\w+.]+)[%s]*;");
    private final List<JavaClass> all = new ArrayList<JavaClass>();

    public JavaFile(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.initFromReader(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void initFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher2 matcher2 = packageDefinition.matcher(string = StringUtils.trin(string));
            if (matcher2.find()) {
                string2 = matcher2.group(1);
                continue;
            }
            Matcher2 matcher22 = classDefinition.matcher(string);
            if (!matcher22.find()) continue;
            String string3 = matcher22.group(2);
            String string4 = matcher22.group(4);
            LeafType leafType = LeafType.valueOf(StringUtils.goUpperCase(matcher22.group(1)));
            LeafType leafType2 = JavaFile.getParentType(leafType, matcher22.group(3));
            this.all.add(new JavaClass(string2, string3, string4, leafType, leafType2));
        }
    }

    static LeafType getParentType(LeafType leafType, String string) {
        if (string == null) {
            return null;
        }
        if (leafType == LeafType.CLASS) {
            if (string.equals("extends")) {
                return LeafType.CLASS;
            }
            return LeafType.INTERFACE;
        }
        return LeafType.INTERFACE;
    }

    public List<JavaClass> getJavaClasses() {
        return Collections.unmodifiableList(this.all);
    }
}

