/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.bpm.AbstractConnectorPuzzle;
import net.sourceforge.plantuml.bpm.BpmElement;
import net.sourceforge.plantuml.bpm.Cell;
import net.sourceforge.plantuml.bpm.Chain;
import net.sourceforge.plantuml.bpm.ChainImpl;
import net.sourceforge.plantuml.bpm.Col;
import net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import net.sourceforge.plantuml.bpm.ConnectorPuzzleEmpty;
import net.sourceforge.plantuml.bpm.Coord;
import net.sourceforge.plantuml.bpm.GridArray;
import net.sourceforge.plantuml.bpm.Line;
import net.sourceforge.plantuml.bpm.Navigator;
import net.sourceforge.plantuml.bpm.Navigators;
import net.sourceforge.plantuml.bpm.Placeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid {
    private final Chain<Line> lines;
    private final Chain<Col> cols;
    private final Coord root;
    private final Map<Coord, Cell> cells = new HashMap<Coord, Cell>();

    public Grid() {
        this.root = new Coord(new Line(), new Col());
        this.lines = new ChainImpl<Line>(this.root.getLine());
        this.cols = new ChainImpl<Col>(this.root.getCol());
        this.cells.put(this.root, new Cell());
    }

    private Grid(Grid grid) {
        this.lines = ((ChainImpl)grid.lines).cloneMe();
        this.cols = ((ChainImpl)grid.cols).cloneMe();
        this.root = grid.root;
        this.cells.putAll(grid.cells);
    }

    public Grid cloneMe() {
        return new Grid(this);
    }

    public Cell getCell(Coord coord) {
        return this.getCell(coord.getLine(), coord.getCol());
    }

    public Cell getCell(Line line, Col col) {
        if (!this.lines.contains(line)) {
            throw new IllegalArgumentException();
        }
        if (!this.cols.contains(col)) {
            throw new IllegalArgumentException();
        }
        Coord coord = new Coord(line, col);
        Cell cell2 = this.cells.get(coord);
        if (cell2 == null) {
            cell2 = new Cell();
            this.cells.put(coord, cell2);
        }
        return cell2;
    }

    public Coord getById(String string) {
        for (Map.Entry<Coord, Cell> entry : this.cells.entrySet()) {
            Cell cell2 = entry.getValue();
            if (cell2 == null || cell2.getData() == null || !string.equals(cell2.getData().getId())) continue;
            return entry.getKey();
        }
        return null;
    }

    public final Coord getRoot() {
        return this.root;
    }

    public final Chain<Line> lines() {
        return this.lines;
    }

    public final Chain<Col> cols() {
        return this.cols;
    }

    public final Coord getCoord(Cell cell2) {
        for (Map.Entry<Coord, Cell> entry : this.cells.entrySet()) {
            if (entry.getValue() != cell2) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException();
    }

    private Coord getCoord(Placeable placeable) {
        for (Map.Entry<Coord, Cell> entry : this.cells.entrySet()) {
            if (entry.getValue().getData() != placeable) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException();
    }

    public final Navigator<Line> linesOf(Coord coord) {
        return this.lines.navigator(coord.getLine());
    }

    public final Navigator<Col> colsOf(Coord coord) {
        return this.cols.navigator(coord.getCol());
    }

    public final Navigator<Line> linesOf(Cell cell2) {
        return this.linesOf(this.getCoord(cell2));
    }

    public final Navigator<Col> colsOf(Cell cell2) {
        return this.colsOf(this.getCoord(cell2));
    }

    public final GridArray toArray(ISkinParam iSkinParam) {
        List<Line> list = this.lines.toList();
        List<Col> list2 = this.cols.toList();
        GridArray gridArray = new GridArray(iSkinParam, list.size(), list2.size());
        for (Map.Entry<Coord, Cell> entry : this.cells.entrySet()) {
            int n = list.indexOf(entry.getKey().getLine());
            int n2 = list2.indexOf(entry.getKey().getCol());
            if (n2 == -1) {
                throw new IllegalStateException("col=" + entry.getKey().getCol());
            }
            if (n == -1) {
                throw new IllegalStateException("line=" + entry.getKey().getLine());
            }
            gridArray.setData(n, n2, entry.getValue().getData());
        }
        return gridArray;
    }

    public Set<Col> usedColsOf(Line line) {
        HashSet<Col> hashSet = new HashSet<Col>();
        for (Map.Entry<Coord, Cell> entry : this.cells.entrySet()) {
            Cell cell2 = entry.getValue();
            if (cell2 == null || cell2.getData() == null || entry.getKey().getLine() != line) continue;
            hashSet.add(entry.getKey().getCol());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void removeLine(Line line) {
        assert (this.usedColsOf(line).isEmpty());
        Iterator<Map.Entry<Coord, Cell>> iterator = this.cells.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Coord, Cell> entry = iterator.next();
            if (entry.getKey().getLine() != line) continue;
            Cell cell2 = entry.getValue();
            if (cell2 == null || cell2.getData() == null) {
                iterator.remove();
                continue;
            }
            throw new IllegalStateException();
        }
        boolean bl = this.lines.remove(line);
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public void addConnections() {
        for (Map.Entry<Coord, Cell> entry : new HashMap<Coord, Cell>(this.cells).entrySet()) {
            List<Placeable> list = entry.getValue().getDestinations2();
            Coord coord = entry.getKey();
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Coord coord2 = this.getCoord(list.get(i));
                boolean bl2 = bl = i == 0;
                if (bl) {
                    this.drawStartHorizontal(coord, coord2);
                    continue;
                }
                this.drawStartVertical(coord, coord2);
            }
        }
    }

    private void drawStartVertical(Coord coord, Coord coord2) {
        Object object;
        if (coord.getLine() == coord2.getLine() && coord.getCol() == coord2.getCol()) {
            throw new IllegalStateException();
        }
        BpmElement bpmElement = (BpmElement)this.getCell(coord).getData();
        int n = this.lines.compare(coord.getLine(), coord2.getLine());
        if (n == 0) {
            throw new IllegalStateException();
        }
        bpmElement.append(n < 0 ? ConnectorPuzzle.Where.SOUTH : ConnectorPuzzle.Where.NORTH);
        Object object2 = Navigators.iterate(this.lines, coord.getLine(), coord2.getLine());
        while (object2.get() != coord2.getLine()) {
            object = object2.next();
            if (object == coord2.getLine()) continue;
            this.addPuzzle((Line)object, coord.getCol(), "NS");
        }
        object2 = Navigators.iterate(this.cols, coord.getCol(), coord2.getCol());
        while (object2.get() != coord2.getCol()) {
            object = (Col)object2.next();
            if (object == coord2.getCol()) continue;
            this.addPuzzle(coord2.getLine(), (Col)object, "EW");
        }
        object2 = (BpmElement)this.getCell(coord2).getData();
        if (coord.getLine() == coord2.getLine()) {
            ((AbstractConnectorPuzzle)object2).append(n < 0 ? ConnectorPuzzle.Where.NORTH : ConnectorPuzzle.Where.SOUTH);
        }
        if (coord.getLine() != coord2.getLine() && coord.getCol() != coord2.getCol()) {
            if (this.lines.compare(coord2.getLine(), coord.getLine()) > 0) {
                this.addPuzzle(coord2.getLine(), coord.getCol(), "N");
            } else {
                this.addPuzzle(coord2.getLine(), coord.getCol(), "S");
            }
            if (this.cols.compare(coord2.getCol(), coord.getCol()) > 0) {
                this.addPuzzle(coord2.getLine(), coord.getCol(), "E");
            } else {
                this.addPuzzle(coord2.getLine(), coord.getCol(), "W");
            }
            ((AbstractConnectorPuzzle)object2).append(this.cols.compare(coord.getCol(), coord2.getCol()) > 0 ? ConnectorPuzzle.Where.EAST : ConnectorPuzzle.Where.WEST);
        }
    }

    private void drawStartHorizontal(Coord coord, Coord coord2) {
        Object object;
        if (coord.getLine() == coord2.getLine() && coord.getCol() == coord2.getCol()) {
            throw new IllegalStateException();
        }
        BpmElement bpmElement = (BpmElement)this.getCell(coord).getData();
        int n = this.cols.compare(coord.getCol(), coord2.getCol());
        if (n == 0) {
            throw new IllegalStateException();
        }
        bpmElement.append(n < 0 ? ConnectorPuzzle.Where.EAST : ConnectorPuzzle.Where.WEST);
        Object object2 = Navigators.iterate(this.cols, coord.getCol(), coord2.getCol());
        while (object2.get() != coord2.getCol()) {
            object = object2.next();
            if (object == coord2.getCol()) continue;
            this.addPuzzle(coord.getLine(), (Col)object, "EW");
        }
        object2 = Navigators.iterate(this.lines, coord.getLine(), coord2.getLine());
        while (object2.get() != coord2.getLine()) {
            object = (Line)object2.next();
            if (object == coord2.getLine()) continue;
            this.addPuzzle((Line)object, coord2.getCol(), "NS");
        }
        object2 = (BpmElement)this.getCell(coord2).getData();
        if (coord.getLine() == coord2.getLine()) {
            ((AbstractConnectorPuzzle)object2).append(n < 0 ? ConnectorPuzzle.Where.WEST : ConnectorPuzzle.Where.EAST);
        }
        if (coord.getLine() != coord2.getLine() && coord.getCol() != coord2.getCol()) {
            if (this.cols.compare(coord2.getCol(), coord.getCol()) > 0) {
                this.addPuzzle(coord.getLine(), coord2.getCol(), "W");
            } else {
                this.addPuzzle(coord.getLine(), coord2.getCol(), "E");
            }
            if (this.lines.compare(coord2.getLine(), coord.getLine()) > 0) {
                this.addPuzzle(coord.getLine(), coord2.getCol(), "S");
            } else {
                this.addPuzzle(coord.getLine(), coord2.getCol(), "N");
            }
            ((AbstractConnectorPuzzle)object2).append(this.lines.compare(coord.getLine(), coord2.getLine()) > 0 ? ConnectorPuzzle.Where.SOUTH : ConnectorPuzzle.Where.NORTH);
        }
    }

    private void addPuzzle(Line line, Col col, String string) {
        Cell cell2 = this.getCell(line, col);
        ConnectorPuzzleEmpty connectorPuzzleEmpty = (ConnectorPuzzleEmpty)cell2.getData();
        if (connectorPuzzleEmpty == null) {
            connectorPuzzleEmpty = new ConnectorPuzzleEmpty();
            cell2.setData(connectorPuzzleEmpty);
        }
        connectorPuzzleEmpty.append(ConnectorPuzzleEmpty.get(string));
    }
}

