/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActor
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final AsciiShape shape;

    public ComponentTextActor(ComponentType componentType, Display display, FileFormat fileFormat, AsciiShape asciiShape) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
        this.shape = asciiShape;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.fillRect(' ', 0, 0, n, n2);
        int n3 = n / 2 - 1;
        if (this.type == ComponentType.ACTOR_HEAD) {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, this.getHeight());
            if (this.fileFormat == FileFormat.UTXT) {
                umlCharArea.drawShape(AsciiShape.STICKMAN_UNICODE, n3, 0);
            } else {
                umlCharArea.drawShape(AsciiShape.STICKMAN, n3, 0);
            }
        } else if (this.type == ComponentType.ACTOR_TAIL) {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, 0);
            if (this.fileFormat == FileFormat.UTXT) {
                umlCharArea.drawShape(AsciiShape.STICKMAN_UNICODE, n3, 1);
            } else {
                umlCharArea.drawShape(AsciiShape.STICKMAN, n3, 1);
            }
        } else assert (false);
    }

    private int getHeight() {
        if (this.fileFormat == FileFormat.UTXT) {
            return AsciiShape.STICKMAN_UNICODE.getHeight();
        }
        return AsciiShape.STICKMAN.getHeight();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getHeight();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

