/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileWithNotes
extends AbstractFtile {
    private final Ftile tile;
    private TextBlock left;
    private TextBlock right;
    private final double suppSpace = 20.0;

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNotes(Ftile ftile, Collection<PositionedNote> collection, ISkinParam iSkinParam) {
        super(ftile.skinParam());
        this.tile = ftile;
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(iSkinParam, ColorParam.noteBackground);
        HtmlColor htmlColor2 = rose.getHtmlColor(iSkinParam, ColorParam.noteBorder);
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.NOTE, null);
        for (PositionedNote positionedNote : collection) {
            Sheet sheet = new CreoleParser(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), iSkinParam, CreoleMode.FULL).createSheet(positionedNote.getDisplay());
            final SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, iSkinParam.getPadding());
            SheetBlock2 sheetBlock2 = new SheetBlock2(sheetBlock1, new Stencil(){

                public double getStartingX(StringBounder stringBounder, double d) {
                    return -6.0;
                }

                public double getEndingX(StringBounder stringBounder, double d) {
                    return sheetBlock1.getEndingX(stringBounder, d) + 15.0;
                }
            }, new UStroke());
            Opale opale = new Opale(htmlColor2, htmlColor, sheetBlock2, iSkinParam.shadowing(), false);
            TextBlock textBlock = TextBlockUtils.withMargin(opale, 10.0, 10.0);
            if (positionedNote.getNotePosition() == NotePosition.LEFT) {
                if (this.left == null) {
                    this.left = textBlock;
                    continue;
                }
                this.left = TextBlockUtils.mergeTB(this.left, textBlock, HorizontalAlignment.CENTER);
                continue;
            }
            if (this.right == null) {
                this.right = textBlock;
                continue;
            }
            this.right = TextBlockUtils.mergeTB(this.right, textBlock, HorizontalAlignment.CENTER);
        }
        if (this.left == null) {
            this.left = TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.right == null) {
            this.right = TextBlockUtils.empty(0.0, 0.0);
        }
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        double d = this.left.calculateDimension(stringBounder).getWidth();
        double d2 = (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight()) / 2.0;
        return new UTranslate(d, d2);
    }

    private UTranslate getTranslateForLeft(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.left.calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
        return new UTranslate(0.0, d);
    }

    private UTranslate getTranslateForRight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.right.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - dimension2D2.getWidth();
        double d2 = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
        return new UTranslate(d, d2);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.left.drawU(uGraphic.apply(this.getTranslateForLeft(stringBounder)));
        this.right.drawU(uGraphic.apply(this.getTranslateForRight(stringBounder)));
        uGraphic.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        UTranslate uTranslate = this.getTranslate(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy(), ftileGeometry.getOutY() + uTranslate.getDy());
        }
        return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.left.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.right.calculateDimension(stringBounder);
        double d = MathUtils.max(dimension2D.getHeight(), dimension2D2.getHeight(), ((Dimension2D)ftileGeometry).getHeight());
        return new Dimension2DDouble(((Dimension2D)ftileGeometry).getWidth() + dimension2D.getWidth() + dimension2D2.getWidth(), d);
    }
}

