/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNoteLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandNoteLong3() {
        super(CommandNoteLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?note$";
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, BlocLines blocLines) {
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        blocLines = blocLines.subExtract(1, 1);
        blocLines = blocLines.removeEmptyColumns();
        NotePosition notePosition = NotePosition.defaultLeft(regexResult.get("POSITION", 0));
        NoteType noteType = NoteType.defaultType(regexResult.get("TYPE", 0));
        Display display = blocLines.toDisplay();
        Colors colors = CommandNoteLong3.color().getColor(regexResult, activityDiagram3.getSkinParam().getIHtmlColorSet());
        return activityDiagram3.addNote(display, notePosition, noteType, colors);
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(note|floating note)"), new RegexLeaf("POSITION", "[%s]*(left|right)?"), new RegexLeaf("[%s]*"), CommandNoteLong3.color().getRegex(), new RegexLeaf("$"));
    }
}

