/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

public class UrlBuilder {
    private static final String URL_PATTERN = "\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\]";
    private final String topurl;
    private ModeUrl mode;

    public UrlBuilder(String string, ModeUrl modeUrl) {
        this.topurl = string;
        this.mode = modeUrl;
    }

    public Url getUrl(String string) {
        Pattern2 pattern2;
        if (this.mode == ModeUrl.STRICT) {
            pattern2 = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\]$");
        } else if (this.mode == ModeUrl.ANYWHERE) {
            pattern2 = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\].*");
        } else {
            throw new IllegalStateException();
        }
        Matcher2 matcher2 = pattern2.matcher(StringUtils.trinNoTrace(string));
        if (!matcher2.matches()) {
            return null;
        }
        String string2 = matcher2.group(1);
        String string3 = matcher2.group(2);
        int n = string3.indexOf(123);
        int n2 = string3.lastIndexOf(125);
        if (string2 == null) {
            if (n != -1 && n2 != -1) {
                return new Url(this.withTopUrl(string3.substring(0, n)), string3.substring(n + 1, n2), string3.substring(n2 + 1).trim());
            }
            int n3 = string3.indexOf(32);
            if (n3 == -1) {
                return new Url(string3, null, null);
            }
            return new Url(this.withTopUrl(string3.substring(0, n3)), null, string3.substring(n3 + 1).trim());
        }
        if (n != -1 && n2 != -1) {
            return new Url(this.withTopUrl(string2), string3.substring(n + 1, n2), string3.substring(n2 + 1).trim());
        }
        return new Url(this.withTopUrl(string2), null, null);
    }

    private String withTopUrl(String string) {
        if (!string.startsWith("http:") && !string.startsWith("https:") && this.topurl != null) {
            return this.topurl + string;
        }
        return string;
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModeUrl {
        STRICT,
        ANYWHERE;

    }
}

