/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileImageData;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NamedOutputStream;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemUtils {
    public static List<FileImageData> exportDiagrams(Diagram diagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (diagram instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof ActivityDiagram3) {
            return PSystemUtils.exportDiagramsActivityDiagram3((ActivityDiagram3)diagram, suggestedFile, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(diagram, suggestedFile, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsNewpaged(NewpagedDiagram newpagedDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        int n = newpagedDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            File file = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(file)) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageData imageData = null;
            try {
                newpagedDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
            Log.info("File size : " + file.length());
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    public static boolean canFileBeWritten(File file) {
        Log.info("Creating file: " + file);
        if (file.exists() && !file.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + file);
                file.setWritable(true);
                file.delete();
                return true;
            }
            Log.error("Cannot write to file " + file);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsDefault(Diagram diagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        OutputStream outputStream = null;
        ImageData imageData = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
            imageData = diagram.exportDiagram(outputStream, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsActivityDiagram3(ActivityDiagram3 activityDiagram3, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        OutputStream outputStream = null;
        ImageData imageData = null;
        ImageData imageData2 = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
            imageData2 = imageData = activityDiagram3.exportDiagram(outputStream, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (imageData != null && imageData.containsCMapData()) {
            activityDiagram3.exportCmap(suggestedFile, 0, imageData);
        }
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsSequence(SequenceDiagram sequenceDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        int n = sequenceDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            File file = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(i))) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageData imageData = null;
            try {
                imageData = sequenceDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
            if (imageData != null && imageData.containsCMapData()) {
                sequenceDiagram.exportCmap(suggestedFile, i, imageData);
            }
            Log.info("File size : " + file.length());
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsCuca(CucaDiagram cucaDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
            return PSystemUtils.createFilesHtml(cucaDiagram, suggestedFile);
        }
        ImageData imageData = null;
        OutputStream outputStream = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                List<FileImageData> list = Collections.emptyList();
                return list;
            }
            outputStream = new NamedOutputStream(suggestedFile.getFile(0));
            imageData = cucaDiagram.exportDiagram(outputStream, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        List<File> list = Arrays.asList(suggestedFile.getFile(0));
        if (imageData != null && imageData.containsCMapData()) {
            cucaDiagram.exportCmap(suggestedFile, 0, imageData);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(suggestedFile, cucaDiagram.getHorizontalPages(), cucaDiagram.getVerticalPages(), cucaDiagram.getMetadata(), cucaDiagram.getDpi(fileFormatOption), fileFormatOption.isWithMetadata(), cucaDiagram.getSkinParam().getSplitParam()).getFiles();
        }
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        for (File file : list) {
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    private static List<FileImageData> createFilesHtml(CucaDiagram cucaDiagram, SuggestedFile suggestedFile) throws IOException {
        String string = suggestedFile.getName();
        int n = string.lastIndexOf(46);
        File file = new File(suggestedFile.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(cucaDiagram, file);
        return cucaDiagramHtmlMaker.create();
    }
}

