/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.compositediagram.CompositeDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.creole.PSystemCreoleFactory;
import net.sourceforge.plantuml.cute.PSystemCuteFactory;
import net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemLostFactory;
import net.sourceforge.plantuml.eggs.PSystemPathFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.jungle.PSystemTreeFactory;
import net.sourceforge.plantuml.logo.PSystemLogoFactory;
import net.sourceforge.plantuml.math.PSystemLatexFactory;
import net.sourceforge.plantuml.math.PSystemMathFactory;
import net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.postit.PostIdDiagramFactory;
import net.sourceforge.plantuml.printskin.PrintSkinFactory;
import net.sourceforge.plantuml.project3.GanttDiagramFactory;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import net.sourceforge.plantuml.ugraphic.sprite.PSystemListInternalSpritesFactory;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(List<CharSequence2> list, int n) {
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            Object object2;
            DiagramType diagramType = DiagramType.getTypeFromArobaseStart(list.get(0).toString2());
            UmlSource umlSource = new UmlSource(list, diagramType == DiagramType.UML, n);
            for (CharSequence2 object32 : list) {
                if (object32.getPreprocessorError() == null) continue;
                Log.error("Preprocessor Error: " + object32.getPreprocessorError());
                ErrorUml list2 = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, object32.getPreprocessorError(), object32.getLocation());
                PSystemError object5 = new PSystemError(umlSource, list2, Collections.<String>emptyList());
                return object5;
            }
            Object object4 = umlSource.getDiagramType();
            ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
            List<PSystemFactory> list2 = this.getAllFactories();
            Object object3 = list2.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (object4 != object2.getDiagramType()) continue;
                Diagram diagram = object2.createSystem(umlSource);
                if (this.isOk(diagram)) {
                    object = diagram;
                    Diagram diagram2 = diagram;
                    return diagram2;
                }
                arrayList.add((PSystemError)diagram);
            }
            object = object3 = PSystemError.merge(arrayList);
            object2 = object3;
            return object2;
        }
        finally {
            if (object != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - l, object.getClass());
            }
        }
    }

    private List<PSystemFactory> getAllFactories() {
        ArrayList<PSystemFactory> arrayList = new ArrayList<PSystemFactory>();
        arrayList.add(new PSystemWelcomeFactory());
        arrayList.add(new PSystemColorsFactory());
        arrayList.add(new SequenceDiagramFactory());
        arrayList.add(new ClassDiagramFactory());
        arrayList.add(new ActivityDiagramFactory());
        arrayList.add(new DescriptionDiagramFactory());
        arrayList.add(new StateDiagramFactory());
        arrayList.add(new ActivityDiagramFactory3());
        arrayList.add(new CompositeDiagramFactory());
        arrayList.add(new BpmDiagramFactory(DiagramType.BPM));
        arrayList.add(new PostIdDiagramFactory());
        arrayList.add(new PrintSkinFactory());
        arrayList.add(new PSystemLicenseFactory());
        arrayList.add(new PSystemVersionFactory());
        arrayList.add(new PSystemDonorsFactory());
        arrayList.add(new PSystemListFontsFactory());
        arrayList.add(new PSystemOpenIconicFactory());
        arrayList.add(new PSystemListOpenIconicFactory());
        arrayList.add(new PSystemListInternalSpritesFactory());
        arrayList.add(new PSystemSaltFactory(DiagramType.SALT));
        arrayList.add(new PSystemSaltFactory(DiagramType.UML));
        arrayList.add(new PSystemDotFactory(DiagramType.DOT));
        arrayList.add(new PSystemDotFactory(DiagramType.UML));
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            arrayList.add(new PSystemDitaaFactory(DiagramType.DITAA));
            arrayList.add(new PSystemDitaaFactory(DiagramType.UML));
            arrayList.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            arrayList.add(new PSystemJcckitFactory(DiagramType.UML));
            arrayList.add(new PSystemLogoFactory());
            arrayList.add(new PSystemSudokuFactory());
        }
        arrayList.add(new PSystemDefinitionFactory());
        arrayList.add(new PSystemMathFactory(DiagramType.MATH));
        arrayList.add(new PSystemLatexFactory(DiagramType.LATEX));
        arrayList.add(new PSystemCreoleFactory());
        arrayList.add(new PSystemEggFactory());
        arrayList.add(new PSystemAppleTwoFactory());
        arrayList.add(new PSystemRIPFactory());
        arrayList.add(new PSystemLostFactory());
        arrayList.add(new PSystemPathFactory());
        arrayList.add(new PSystemOregonFactory());
        arrayList.add(new PSystemCharlieFactory());
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            arrayList.add(new PSystemXearthFactory());
        }
        arrayList.add(new GanttDiagramFactory());
        arrayList.add(new FlowDiagramFactory());
        arrayList.add(new PSystemTreeFactory(DiagramType.JUNGLE));
        arrayList.add(new PSystemCuteFactory(DiagramType.CUTE));
        arrayList.add(new PSystemDedicationFactory());
        arrayList.add(new TimingDiagramFactory());
        return arrayList;
    }

    private boolean isOk(Diagram diagram) {
        return diagram != null && !(diagram instanceof PSystemError);
    }
}

