/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileGroup;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.stats.StatsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option {
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> config = new ArrayList<String>();
    private final Map<String, String> defines = new LinkedHashMap<String, String>();
    private String charset;
    private boolean computeurl = false;
    private boolean decodeurl = false;
    private boolean pipe = false;
    private String pipeDelimitor;
    private boolean pipeMap = false;
    private boolean pipeNoStdErr = false;
    private boolean syntax = false;
    private boolean checkOnly = false;
    private boolean failfast = false;
    private boolean failfast2 = false;
    private boolean pattern = false;
    private boolean duration = false;
    private boolean debugsvek = false;
    private boolean splash = false;
    private boolean textProgressBar = false;
    private int nbThreads = 0;
    private int ftpPort = -1;
    private boolean hideMetadata = false;
    private int imageIndex = 0;
    private File outputDir = null;
    private File outputFile = null;
    private final List<String> result = new ArrayList<String>();
    private FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);

    public Option() {
    }

    @Deprecated
    public final void setFileFormat(FileFormat fileFormat) {
        this.setFileFormatOption(new FileFormatOption(fileFormat));
    }

    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public Option(String ... stringArray) throws InterruptedException, IOException {
        if (stringArray.length == 0) {
            OptionFlags.getInstance().setGui(true);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equalsIgnoreCase("-tsvg") || string.equalsIgnoreCase("-svg")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
                continue;
            }
            if (string.equalsIgnoreCase("-tsvg:nornd") || string.equalsIgnoreCase("-svg:nornd")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
                continue;
            }
            if (string.equalsIgnoreCase("-thtml") || string.equalsIgnoreCase("-html")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.HTML));
                continue;
            }
            if (string.equalsIgnoreCase("-tscxml") || string.equalsIgnoreCase("-scxml")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SCXML));
                continue;
            }
            if (string.equalsIgnoreCase("-txmi") || string.equalsIgnoreCase("-xmi")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
                continue;
            }
            if (string.equalsIgnoreCase("-txmi:argo") || string.equalsIgnoreCase("-xmi:argo")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
                continue;
            }
            if (string.equalsIgnoreCase("-txmi:star") || string.equalsIgnoreCase("-xmi:star")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
                continue;
            }
            if (string.equalsIgnoreCase("-teps") || string.equalsIgnoreCase("-eps")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
                continue;
            }
            if (string.equalsIgnoreCase("-teps:text") || string.equalsIgnoreCase("-eps:text")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
                continue;
            }
            if (string.equalsIgnoreCase("-ttxt") || string.equalsIgnoreCase("-txt")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
                continue;
            }
            if (string.equalsIgnoreCase("-tutxt") || string.equalsIgnoreCase("-utxt")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
                continue;
            }
            if (string.equalsIgnoreCase("-braille") || string.equalsIgnoreCase("-tbraille")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.BRAILLE_PNG));
                continue;
            }
            if (string.equalsIgnoreCase("-png") || string.equalsIgnoreCase("-tpng")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.PNG));
                continue;
            }
            if (string.equalsIgnoreCase("-vdx") || string.equalsIgnoreCase("-tvdx")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.VDX));
                continue;
            }
            if (string.equalsIgnoreCase("-latex") || string.equalsIgnoreCase("-tlatex")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.LATEX));
                continue;
            }
            if (string.equalsIgnoreCase("-latex:nopreamble") || string.equalsIgnoreCase("-tlatex:nopreamble")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.LATEX_NO_PREAMBLE));
                continue;
            }
            if (string.equalsIgnoreCase("-base64") || string.equalsIgnoreCase("-tbase64")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.BASE64));
                continue;
            }
            if (string.equalsIgnoreCase("-pdf") || string.equalsIgnoreCase("-tpdf")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
                continue;
            }
            if (string.equalsIgnoreCase("-overwrite")) {
                OptionFlags.getInstance().setOverwrite(true);
                continue;
            }
            if (string.equalsIgnoreCase("-output") || string.equalsIgnoreCase("-o")) {
                if (++i == stringArray.length) continue;
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-ofile")) {
                if (++i == stringArray.length) continue;
                this.outputFile = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-graphvizdot") || string.equalsIgnoreCase("-graphviz_dot")) {
                if (++i == stringArray.length) continue;
                GraphvizUtils.setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-charset")) {
                if (++i == stringArray.length) continue;
                this.charset = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]);
                continue;
            }
            if (string.startsWith("-o") && string.length() > 3) {
                string = string.substring(2);
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            if (string.equalsIgnoreCase("-recurse") || string.equalsIgnoreCase("-r")) continue;
            if (string.equalsIgnoreCase("-exclude") || string.equalsIgnoreCase("-x")) {
                if (++i == stringArray.length) continue;
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-nbthread") || string.equalsIgnoreCase("-nbthreads")) {
                if (++i == stringArray.length) continue;
                String string2 = stringArray[i];
                if ("auto".equalsIgnoreCase(string2)) {
                    this.nbThreads = Option.defaultNbThreads();
                    continue;
                }
                if (!string2.matches("\\d+")) continue;
                this.nbThreads = Integer.parseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("-timeout")) {
                String string3;
                if (++i == stringArray.length || !(string3 = stringArray[i]).matches("\\d+")) continue;
                OptionFlags.getInstance().setTimeoutMs((long)Integer.parseInt(string3) * 1000L);
                continue;
            }
            if (string.equalsIgnoreCase("-failfast")) {
                this.failfast = true;
                continue;
            }
            if (string.equalsIgnoreCase("-failfast2")) {
                this.failfast2 = true;
                continue;
            }
            if (string.equalsIgnoreCase("-checkonly")) {
                this.checkOnly = true;
                continue;
            }
            if (string.equalsIgnoreCase("-config")) {
                if (++i == stringArray.length) continue;
                this.initConfig(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.startsWith("-I")) {
                this.initInclude(string.substring(2));
                continue;
            }
            if (string.equalsIgnoreCase("-computeurl") || string.equalsIgnoreCase("-encodeurl")) {
                this.computeurl = true;
                continue;
            }
            if (string.startsWith("-x")) {
                string = string.substring(2);
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                OptionFlags.getInstance().setVerbose(true);
                continue;
            }
            if (string.equalsIgnoreCase("-pipe") || string.equalsIgnoreCase("-p")) {
                this.pipe = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pipedelimitor")) {
                if (++i == stringArray.length) continue;
                this.pipeDelimitor = stringArray[i];
                continue;
            }
            if (string.equalsIgnoreCase("-pipemap")) {
                this.pipeMap = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pipenostderr")) {
                this.pipeNoStdErr = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pattern")) {
                this.pattern = true;
                continue;
            }
            if (string.equalsIgnoreCase("-syntax")) {
                this.syntax = true;
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (string.equalsIgnoreCase("-duration")) {
                this.duration = true;
                continue;
            }
            if (string.equalsIgnoreCase("-debugsvek") || string.equalsIgnoreCase("-debug_svek")) {
                this.debugsvek = true;
                continue;
            }
            if (string.equalsIgnoreCase("-keepfiles") || string.equalsIgnoreCase("-keepfile")) {
                System.err.println("-keepfiles option has been removed. Please consider -debugsvek instead");
                continue;
            }
            if (string.equalsIgnoreCase("-metadata")) {
                OptionFlags.getInstance().setExtractFromMetadata(true);
                continue;
            }
            if (string.equalsIgnoreCase("-logdata")) {
                if (++i == stringArray.length) continue;
                OptionFlags.getInstance().setLogData(new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i])));
                continue;
            }
            if (string.equalsIgnoreCase("-word")) {
                OptionFlags.getInstance().setWord(true);
                OptionFlags.getInstance().setQuiet(true);
                this.charset = "UTF-8";
                continue;
            }
            if (string.equalsIgnoreCase("-quiet")) {
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (string.equalsIgnoreCase("-decodeurl")) {
                this.decodeurl = true;
                continue;
            }
            if (string.equalsIgnoreCase("-version")) {
                OptionPrint.printVersion();
                continue;
            }
            if (string.matches("(?i)^-li[sc][ea]n[sc]e\\s*$")) {
                OptionPrint.printLicense();
                continue;
            }
            if (string.equalsIgnoreCase("-checkversion")) {
                OptionPrint.checkVersion();
                continue;
            }
            if (string.startsWith("-D")) {
                this.manageDefine(string.substring(2));
                continue;
            }
            if (string.startsWith("-S")) {
                this.manageSkinParam(string.substring(2));
                continue;
            }
            if (string.equalsIgnoreCase("-testdot")) {
                OptionPrint.printTestDot();
                continue;
            }
            if (string.equalsIgnoreCase("-about") || string.equalsIgnoreCase("-author") || string.equalsIgnoreCase("-authors")) {
                OptionPrint.printAbout();
                continue;
            }
            if (string.equalsIgnoreCase("-help") || string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("-?")) {
                OptionPrint.printHelp();
                continue;
            }
            if (string.equalsIgnoreCase("-language")) {
                OptionPrint.printLanguage();
                continue;
            }
            if (string.equalsIgnoreCase("-gui")) {
                OptionFlags.getInstance().setGui(true);
                continue;
            }
            if (string.equalsIgnoreCase("-encodesprite")) {
                OptionFlags.getInstance().setEncodesprite(true);
                continue;
            }
            if (string.equalsIgnoreCase("-nosuggestengine")) {
                OptionFlags.getInstance().setUseSuggestEngine(false);
                continue;
            }
            if (string.equalsIgnoreCase("-printfonts")) {
                OptionFlags.getInstance().setPrintFonts(true);
                continue;
            }
            if (string.equalsIgnoreCase("-dumphtmlstats")) {
                OptionFlags.getInstance().setDumpHtmlStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-dumpstats")) {
                OptionFlags.getInstance().setDumpStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-loopstats")) {
                OptionFlags.getInstance().setLoopStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-enablestats")) {
                OptionFlags.getInstance().setEnableStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-disablestats")) {
                OptionFlags.getInstance().setEnableStats(false);
                continue;
            }
            if (string.equalsIgnoreCase("-htmlstats")) {
                StatsUtils.setHtmlStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-xmlstats")) {
                StatsUtils.setXmlStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-realtimestats")) {
                StatsUtils.setRealTimeStats(true);
                continue;
            }
            if (string.equalsIgnoreCase("-useseparatorminus")) {
                OptionFlags.getInstance().setFileSeparator("-");
                continue;
            }
            if (string.equalsIgnoreCase("-splash")) {
                this.splash = true;
                continue;
            }
            if (string.equalsIgnoreCase("-progress")) {
                this.textProgressBar = true;
                continue;
            }
            if (string.equalsIgnoreCase("-nometadata")) {
                this.hideMetadata = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pipeimageindex")) {
                String string4;
                if (++i == stringArray.length || !(string4 = stringArray[i]).matches("\\d+")) continue;
                this.imageIndex = Integer.parseInt(string4);
                continue;
            }
            if (StringUtils.goLowerCase(string).startsWith("-ftp")) {
                int n = string.indexOf(58);
                if (n == -1) {
                    this.ftpPort = 4242;
                    continue;
                }
                this.ftpPort = Integer.parseInt(string.substring(n + 1));
                continue;
            }
            if (string.startsWith("-c")) {
                string = string.substring(2);
                this.config.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            this.result.add(string);
        }
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInConfig(FileReader fileReader) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(fileReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.config.add(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public void initConfig(String string) throws IOException {
        this.addInConfig(new FileReader(string));
    }

    private void initInclude(String string) throws IOException {
        if (string.contains("*")) {
            FileGroup fileGroup = new FileGroup(string, Collections.<String>emptyList(), null);
            for (File file : fileGroup.getFiles()) {
                this.addInConfig(new FileReader(file));
            }
        } else {
            this.addInConfig(new FileReader(string));
        }
    }

    private void manageDefine(String string) {
        Pattern2 pattern2 = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            this.define(matcher2.group(1), matcher2.group(2));
        }
    }

    private void manageSkinParam(String string) {
        Pattern2 pattern2 = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            this.skinParam(matcher2.group(1), matcher2.group(2));
        }
    }

    private void skinParam(String string, String string2) {
        if (string != null && string2 != null) {
            this.config.add("skinparamlocked " + string + " " + string2);
        }
    }

    public final File getOutputDir() {
        return this.outputDir;
    }

    public static final String getPattern() {
        return "(?i)^.*\\.(txt|tex|java|htm|html|c|h|cpp|apt|pu)$";
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public final List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public Defines getDefaultDefines(File file) {
        Defines defines = Defines.createWithFileName(file);
        for (Map.Entry<String, String> entry : this.defines.entrySet()) {
            defines.define(entry.getKey(), Arrays.asList(entry.getValue()), false);
        }
        return defines;
    }

    public void define(String string, String string2) {
        this.defines.put(string, string2);
    }

    public List<String> getConfig() {
        return Collections.unmodifiableList(this.config);
    }

    public final List<String> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public final String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public final boolean isComputeurl() {
        return this.computeurl;
    }

    public final boolean isDecodeurl() {
        return this.decodeurl;
    }

    public final boolean isPipe() {
        return this.pipe;
    }

    public final boolean isPipeMap() {
        return this.pipeMap;
    }

    public final boolean isSyntax() {
        return this.syntax;
    }

    public final boolean isPattern() {
        return this.pattern;
    }

    public FileFormatOption getFileFormatOption() {
        if (this.debugsvek) {
            this.fileFormatOption.setDebugSvek(true);
        }
        if (this.hideMetadata) {
            this.fileFormatOption.hideMetadata();
        }
        return this.fileFormatOption;
    }

    public final boolean isDuration() {
        return this.duration;
    }

    public final int getNbThreads() {
        return this.nbThreads;
    }

    public final void setNbThreads(int n) {
        this.nbThreads = n;
    }

    public static int defaultNbThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final boolean isCheckOnly() {
        return this.checkOnly;
    }

    public final void setCheckOnly(boolean bl) {
        this.checkOnly = bl;
    }

    public final boolean isFailfastOrFailfast2() {
        return this.failfast || this.failfast2;
    }

    public final boolean isFailfast2() {
        return this.failfast2;
    }

    public final void setFailfast(boolean bl) {
        this.failfast = bl;
    }

    public final void setFailfast2(boolean bl) {
        this.failfast2 = bl;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void setDebugSvek(boolean bl) {
        this.debugsvek = bl;
    }

    boolean isDebugSvek() {
        return this.debugsvek;
    }

    public final boolean isSplash() {
        return this.splash;
    }

    public final void setSplash(boolean bl) {
        this.splash = bl;
    }

    public final boolean isTextProgressBar() {
        return this.textProgressBar;
    }

    public String getPipeDelimitor() {
        return this.pipeDelimitor;
    }

    public final boolean isPipeNoStdErr() {
        return this.pipeNoStdErr;
    }

    public final int getImageIndex() {
        return this.imageIndex;
    }
}

