/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

class NeuQuant {
    protected static final int netsize = 256;
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    protected static final int maxnetpos = 255;
    protected static final int netbiasshift = 4;
    protected static final int ncycles = 100;
    protected static final int intbiasshift = 16;
    protected static final int intbias = 65536;
    protected static final int gammashift = 10;
    protected static final int gamma = 1024;
    protected static final int betashift = 10;
    protected static final int beta = 64;
    protected static final int betagamma = 65536;
    protected static final int initrad = 32;
    protected static final int radiusbiasshift = 6;
    protected static final int radiusbias = 64;
    protected static final int initradius = 2048;
    protected static final int radiusdec = 30;
    protected static final int alphabiasshift = 10;
    protected static final int initalpha = 1024;
    protected int alphadec;
    protected static final int radbiasshift = 8;
    protected static final int radbias = 256;
    protected static final int alpharadbshift = 18;
    protected static final int alpharadbias = 262144;
    protected byte[] thepicture;
    protected int lengthcount;
    protected int samplefac;
    protected int[][] network;
    protected int[] netindex = new int[256];
    protected int[] bias = new int[256];
    protected int[] freq = new int[256];
    protected int[] radpower = new int[32];

    public NeuQuant(byte[] byArray, int n, int n2) {
        this.thepicture = byArray;
        this.lengthcount = n;
        this.samplefac = n2;
        this.network = new int[256][];
        for (int i = 0; i < 256; ++i) {
            this.network[i] = new int[4];
            int[] nArray = this.network[i];
            nArray[1] = nArray[2] = (i << 12) / 256;
            nArray[0] = nArray[2];
            this.freq[i] = 256;
            this.bias[i] = 0;
        }
    }

    public byte[] colorMap() {
        int n;
        byte[] byArray = new byte[768];
        int[] nArray = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray[this.network[n][3]] = n;
        }
        n = 0;
        for (int i = 0; i < 256; ++i) {
            int n2 = nArray[i];
            byArray[n++] = (byte)this.network[n2][0];
            byArray[n++] = (byte)this.network[n2][1];
            byArray[n++] = (byte)this.network[n2][2];
        }
        return byArray;
    }

    public void inxbuild() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 256; ++i) {
            int[] nArray;
            int[] nArray2 = this.network[i];
            int n4 = i;
            int n5 = nArray2[1];
            for (n = i + 1; n < 256; ++n) {
                nArray = this.network[n];
                if (nArray[1] >= n5) continue;
                n4 = n;
                n5 = nArray[1];
            }
            nArray = this.network[n4];
            if (i != n4) {
                n = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n;
                n = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n;
                n = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n;
                n = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n;
            }
            if (n5 == n2) continue;
            this.netindex[n2] = n3 + i >> 1;
            for (n = n2 + 1; n < n5; ++n) {
                this.netindex[n] = i;
            }
            n2 = n5;
            n3 = i;
        }
        this.netindex[n2] = n3 + 255 >> 1;
        for (n = n2 + 1; n < 256; ++n) {
            this.netindex[n] = 255;
        }
    }

    public void learn() {
        int n;
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        byte[] byArray = this.thepicture;
        int n2 = 0;
        int n3 = this.lengthcount;
        int n4 = this.lengthcount / (3 * this.samplefac);
        int n5 = n4 / 100;
        int n6 = 1024;
        int n7 = 2048;
        int n8 = n7 >> 6;
        if (n8 <= 1) {
            n8 = 0;
        }
        for (n = 0; n < n8; ++n) {
            this.radpower[n] = n6 * ((n8 * n8 - n * n) * 256 / (n8 * n8));
        }
        int n9 = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        n = 0;
        while (n < n4) {
            int n10 = (byArray[n2 + 0] & 0xFF) << 4;
            int n11 = (byArray[n2 + 1] & 0xFF) << 4;
            int n12 = (byArray[n2 + 2] & 0xFF) << 4;
            int n13 = this.contest(n10, n11, n12);
            this.altersingle(n6, n13, n10, n11, n12);
            if (n8 != 0) {
                this.alterneigh(n8, n13, n10, n11, n12);
            }
            if ((n2 += n9) >= n3) {
                n2 -= this.lengthcount;
            }
            ++n;
            if (n5 == 0) {
                n5 = 1;
            }
            if (n % n5 != 0) continue;
            n6 -= n6 / this.alphadec;
            if ((n8 = (n7 -= n7 / 30) >> 6) <= 1) {
                n8 = 0;
            }
            for (n13 = 0; n13 < n8; ++n13) {
                this.radpower[n13] = n6 * ((n8 * n8 - n13 * n13) * 256 / (n8 * n8));
            }
        }
    }

    public int map(int n, int n2, int n3) {
        int n4 = 1000;
        int n5 = -1;
        int n6 = this.netindex[n2];
        int n7 = n6 - 1;
        while (n6 < 256 || n7 >= 0) {
            int n8;
            int n9;
            int[] nArray;
            if (n6 < 256) {
                nArray = this.network[n6];
                n9 = nArray[1] - n2;
                if (n9 >= n4) {
                    n6 = 256;
                } else {
                    ++n6;
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n8 = nArray[0] - n) < 0) {
                        n8 = -n8;
                    }
                    if ((n9 += n8) < n4) {
                        n8 = nArray[2] - n3;
                        if (n8 < 0) {
                            n8 = -n8;
                        }
                        if ((n9 += n8) < n4) {
                            n4 = n9;
                            n5 = nArray[3];
                        }
                    }
                }
            }
            if (n7 < 0) continue;
            nArray = this.network[n7];
            n9 = n2 - nArray[1];
            if (n9 >= n4) {
                n7 = -1;
                continue;
            }
            --n7;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n8 = nArray[0] - n) < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n8 = nArray[2] - n3;
            if (n8 < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n4 = n9;
            n5 = nArray[3];
        }
        return n5;
    }

    public byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public void unbiasnet() {
        for (int i = 0; i < 256; ++i) {
            int[] nArray = this.network[i];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i][3] = i;
        }
    }

    protected void alterneigh(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n;
        if (n7 < -1) {
            n7 = -1;
        }
        if ((n6 = n2 + n) > 256) {
            n6 = 256;
        }
        int n8 = n2 + 1;
        int n9 = n2 - 1;
        int n10 = 1;
        while (n8 < n6 || n9 > n7) {
            int[] nArray;
            int n11 = this.radpower[n10++];
            if (n8 < n6) {
                nArray = this.network[n8++];
                try {
                    nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
                    nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
                    nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n9 <= n7) continue;
            nArray = this.network[n9--];
            try {
                nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
                nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
                nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    protected void altersingle(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.network[n2];
        nArray[0] = nArray[0] - n * (nArray[0] - n3) / 1024;
        nArray[1] = nArray[1] - n * (nArray[1] - n4) / 1024;
        nArray[2] = nArray[2] - n * (nArray[2] - n5) / 1024;
    }

    protected int contest(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = Integer.MAX_VALUE;
        int n7 = n4 = -1;
        int n8 = 0;
        while (n8 < 256) {
            int n9;
            int n10;
            int[] nArray = this.network[n8];
            int n11 = nArray[0] - n;
            if (n11 < 0) {
                n11 = -n11;
            }
            if ((n10 = nArray[1] - n2) < 0) {
                n10 = -n10;
            }
            n11 += n10;
            n10 = nArray[2] - n3;
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n11 += n10) < n5) {
                n5 = n11;
                n4 = n8;
            }
            if ((n9 = n11 - (this.bias[n8] >> 12)) < n6) {
                n6 = n9;
                n7 = n8;
            }
            int n12 = this.freq[n8] >> 10;
            int n13 = n8;
            this.freq[n13] = this.freq[n13] - n12;
            int n14 = n8++;
            this.bias[n14] = this.bias[n14] + (n12 << 10);
        }
        int n15 = n4;
        this.freq[n15] = this.freq[n15] + 64;
        int n16 = n4;
        this.bias[n16] = this.bias[n16] - 65536;
        return n7;
    }
}

